//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndCRC32.cpp
 * @brief		CRC32 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndCRC32_CPP_

//======================================================================
// include
#include "FndCRC32.h"

namespace iris {
namespace fnd
{


/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
ICRC32::ICRC32(void)
{
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void ICRC32::Init(void)
{
	m_Context = 0xFFFFFFFF;
}

/**********************************************************************//**
 *
 * NA
 *
*//***********************************************************************/
void ICRC32::Clear(void)
{
	Init();
}

/**********************************************************************//**
 *
 * ŏIXV
 *
*//***********************************************************************/
void ICRC32::Final(void)
{
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
*//***********************************************************************/
void ICRC32::GetDigest(u8* lpBuffer)	const
{
	*(pointer_cast<u32*>(lpBuffer)) = m_Context;
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpHashBuffer= nbV
*//***********************************************************************/
void ICRC32::ToStringA(LPSTR  lpString, size_t uSize, u8* lpHashBuffer)	const
{
	sprintf_s(lpString, uSize, "%.8x", *pointer_cast<u32*>(lpHashBuffer));
}
/** @ref ToStringA */
void ICRC32::ToStringW(LPWSTR lpString, size_t uSize, u8* lpHashBuffer)	const
{
	swprintf_s(lpString, uSize, L"%.8x", *pointer_cast<u32*>(lpHashBuffer));
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpBuffer	= nbV
*//***********************************************************************/
void ICRC32::ToStringA(LPSTR  lpString, size_t uSize)	const
{
	_ToStringA<HASHSIZE>(lpString, uSize);
}
/** @ref ToStringA */
void ICRC32::ToStringW(LPWSTR lpString, size_t uSize)	const
{
	_ToStringW<HASHSIZE>(lpString, uSize);
}

}	// end of namespace fnd
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST)) || defined(_IRIS_SUPPORT_GOOGLETEST)

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"

TEST(CFndCRC32Test, Constructor)
{
	ASSERT_NE( CCRC32L<>("test"), CCRC32L<>("test2") );
}
#endif	// #if	defined(_IRIS_SUPPORT_GOOGLETEST)
