//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSHA1.cpp
 * @brief		SHA1 NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndSHA1_CPP_

//======================================================================
// include
#include "FndSHA1.h"

namespace iris {
namespace fnd
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSHA1::CSHA1(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSHA1::~CSHA1(void)
{
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CSHA1::Init(void)
{
	math::SHA1InitContext(&m_Context);
}

/**********************************************************************//**
 *
 * NA
 *
*//***********************************************************************/
void CSHA1::Clear(void)
{
	math::SHA1ClearContext(&m_Context);
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@
*//***********************************************************************/
void CSHA1::Update(const u8* lpBuffer, size_t uLength)
{
	math::SHA1Update(&m_Context, lpBuffer, uLength);
}

/**********************************************************************//**
 *
 * ŏIXV
 *
*//***********************************************************************/
void CSHA1::Final(void)
{
	math::SHA1Final(&m_Context);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
*//***********************************************************************/
void CSHA1::GetDigest(u8* lpBuffer)	const
{
	math::SHA1Output(&m_Context, lpBuffer);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpBuffer	= nbV
*//***********************************************************************/
void CSHA1::ToStringA(LPSTR  lpString, size_t uSize, u8* lpBuffer)	const
{
	math::SHA1ToStringA(lpString, uSize, lpBuffer);
}
void CSHA1::ToStringW(LPWSTR lpString, size_t uSize, u8* lpBuffer)	const
{
	math::SHA1ToStringW(lpString, uSize, lpBuffer);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpBuffer	= nbV
*//***********************************************************************/
void CSHA1::ToStringA(LPSTR  lpString, size_t uSize)	const
{
	_ToStringA<HASHSIZE>(lpString, uSize);
}
void CSHA1::ToStringW(LPWSTR lpString, size_t uSize)	const
{
	_ToStringW<HASHSIZE>(lpString, uSize);
}

}	// end of namespace fnd
}	// end of namespace iris

#if	defined(_IRIS_SUPPORT_GOOGLETEST)

//======================================================================
// include
#include "../../unit/gt/gt_inchead.h"
#include "../../iris_using.h"

TEST(CFndSHA1Test, Function)
{
	char comm[256] = "";
	CSHA1 sha;

	// TEST1
	strcpy_s(comm, 256, "abc");
	sha.Encode(comm, strlen(comm));
	sha.ToStringA(comm, 256);
	ASSERT_STREQ( "a9993e364706816aba3e25717850c26c9cd0d89d"
		, comm );

	// TEST2
	strcpy_s(comm, 256, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq");
	sha.Encode(comm, strlen(comm));
	sha.ToStringA(comm, 256);
	ASSERT_STREQ( "84983e441c3bd26ebaae4aa1f95129e5e54670f1"
		, comm );

	// TEST3
	strcpy_s(comm, 256, "a");
	sha.Init();
	for( int i=0; i < 1000000; ++i )
		sha.Update((const u8*)comm, strlen(comm));
	sha.Final();
	sha.ToStringA(comm, 256);
	ASSERT_STREQ( "34aa973cd4c4daa4f61eeb2bdbad27316534016f"
		, comm );

	// TEST4
	strcpy_s(comm, 256, "01234567012345670123456701234567""01234567012345670123456701234567");
	sha.Init();
	for( int i=0; i < 10; ++i )
		sha.Update((const u8*)comm, strlen(comm));
	sha.Final();
	sha.ToStringA(comm, 256);
	ASSERT_STREQ( "dea356a2cddd90c7a7ecedc5ebb563934f460452"
		, comm );
}

#endif	// #if	defined(_IRIS_SUPPORT_GOOGLETEST)
