//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSHA224.cpp
 * @brief		SHA224 NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndSHA224_CPP_

//======================================================================
// include
#include "FndSHA224.h"

namespace iris {
namespace fnd
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSHA224::CSHA224(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSHA224::~CSHA224(void)
{
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CSHA224::Init(void)
{
	math::SHA224InitContext(&m_Context);
}

/**********************************************************************//**
 *
 * NA
 *
*//***********************************************************************/
void CSHA224::Clear(void)
{
	math::SHA224ClearContext(&m_Context);
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@
*//***********************************************************************/
void CSHA224::Update(const u8* lpBuffer, size_t uLength)
{
	math::SHA224Update(&m_Context, lpBuffer, uLength);
}

/**********************************************************************//**
 *
 * ŏIXV
 *
*//***********************************************************************/
void CSHA224::Final(void)
{
	math::SHA224Final(&m_Context);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
*//***********************************************************************/
void CSHA224::GetDigest(u8* lpBuffer)	const
{
	math::SHA224Output(&m_Context, lpBuffer);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpBuffer	= nbV
*//***********************************************************************/
void CSHA224::ToStringA(LPSTR  lpString, size_t uSize, u8* lpBuffer)	const
{
	math::SHA224ToStringA(lpString, uSize, lpBuffer);
}
void CSHA224::ToStringW(LPWSTR lpString, size_t uSize, u8* lpBuffer)	const
{
	math::SHA224ToStringW(lpString, uSize, lpBuffer);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpBuffer	= nbV
*//***********************************************************************/
void CSHA224::ToStringA(LPSTR  lpString, size_t uSize)	const
{
	_ToStringA<HASHSIZE>(lpString, uSize);
}
void CSHA224::ToStringW(LPWSTR lpString, size_t uSize)	const
{
	_ToStringW<HASHSIZE>(lpString, uSize);
}

}	// end of namespace fnd
}	// end of namespace iris

#if	defined(_IRIS_SUPPORT_GOOGLETEST)

//======================================================================
// include
#include "../../unit/gt/gt_inchead.h"
#include "../../iris_using.h"

TEST(CFndSHA224Test, Function)
{
	char comm[256] = "";
	CSHA224 sha;

	// TEST1
	strcpy_s(comm, 256, "abc");
	sha.Encode(comm, strlen(comm));
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7"
		, comm );

	// TEST2
	strcpy_s(comm, 256, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq");
	sha.Encode(comm, strlen(comm));
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
        "75388b16512776cc5dba5da1fd890150b0c6455cb4f58b1952522525"
		, comm );

	// TEST3
	strcpy_s(comm, 256, "a");
	sha.Init();
	for( int i=0; i < 1000000; ++i )
		sha.Update((const u8*)comm, strlen(comm));
	sha.Final();
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"20794655980c91d8bbb4c1ea97618a4bf03f42581948b2ee4ee7ad67"
		, comm );

	// TEST4
	strcpy_s(comm, 256, "01234567012345670123456701234567""01234567012345670123456701234567");
	sha.Init();
	for( int i=0; i < 10; ++i )
		sha.Update((const u8*)comm, strlen(comm));
	sha.Final();
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"567f69f168cd7844e65259ce658fe7aadfa25216e68eca0eb7ab8262"
		, comm );
}

#endif	// #if	defined(_IRIS_SUPPORT_GOOGLETEST)
