//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSHA384.cpp
 * @brief		SHA384 NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndSHA384_CPP_

//======================================================================
// include
#include "FndSHA384.h"

namespace iris {
namespace fnd
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSHA384::CSHA384(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSHA384::~CSHA384(void)
{
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CSHA384::Init(void)
{
	math::SHA384InitContext(&m_Context);
}

/**********************************************************************//**
 *
 * NA
 *
*//***********************************************************************/
void CSHA384::Clear(void)
{
	math::SHA384ClearContext(&m_Context);
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@
*//***********************************************************************/
void CSHA384::Update(const u8* lpBuffer, size_t uLength)
{
	math::SHA384Update(&m_Context, lpBuffer, uLength);
}

/**********************************************************************//**
 *
 * ŏIXV
 *
*//***********************************************************************/
void CSHA384::Final(void)
{
	math::SHA384Final(&m_Context);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
*//***********************************************************************/
void CSHA384::GetDigest(u8* lpBuffer)	const
{
	math::SHA384Output(&m_Context, lpBuffer);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpBuffer	= nbV
*//***********************************************************************/
void CSHA384::ToStringA(LPSTR  lpString, size_t uSize, u8* lpBuffer)	const
{
	math::SHA384ToStringA(lpString, uSize, lpBuffer);
}
void CSHA384::ToStringW(LPWSTR lpString, size_t uSize, u8* lpBuffer)	const
{
	math::SHA384ToStringW(lpString, uSize, lpBuffer);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpBuffer	= nbV
*//***********************************************************************/
void CSHA384::ToStringA(LPSTR  lpString, size_t uSize)	const
{
	_ToStringA<HASHSIZE>(lpString, uSize);
}
void CSHA384::ToStringW(LPWSTR lpString, size_t uSize)	const
{
	_ToStringW<HASHSIZE>(lpString, uSize);
}

}	// end of namespace fnd
}	// end of namespace iris

#if	defined(_IRIS_SUPPORT_GOOGLETEST)

//======================================================================
// include
#include "../../unit/gt/gt_inchead.h"
#include "../../iris_using.h"

TEST(CFndSHA384Test, Function)
{
	char comm[256] = "";
	CSHA384 sha;

	// TEST1
	strcpy_s(comm, 256, "abc");
	sha.Encode(comm, strlen(comm));
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"cb00753f45a35e8bb5a03d699ac65007272c32ab0eded163"
        "1a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7"
		, comm );

	// TEST2
	strcpy_s(comm, 256, "abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmn"
		"hijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu");
	sha.Encode(comm, strlen(comm));
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
        "09330c33f71147e83d192fc782cd1b4753111b173b3b05d2"
        "2fa08086e3b0f712fcc7c71a557e2db966c3e9fa91746039"
		, comm );

	// TEST3
	strcpy_s(comm, 256, "a");
	sha.Init();
	for( int i=0; i < 1000000; ++i )
		sha.Update((const u8*)comm, strlen(comm));
	sha.Final();
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"9d0e1809716474cb086e834e310a4a1ced149e9c00f24852"
        "7972cec5704c2a5b07b8b3dc38ecc4ebae97ddd87f3d8985"
		, comm );

	// TEST4
	strcpy_s(comm, 256, "01234567012345670123456701234567""01234567012345670123456701234567");
	sha.Init();
	for( int i=0; i < 10; ++i )
		sha.Update((const u8*)comm, strlen(comm));
	sha.Final();
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"2fc64a4f500ddb6828f6a3430b8dd72a368eb7f3a8322a70"
        "bc84275b9c0b3ab00d27a5cc3c2d224aa6b61a0d79fb4596"
		, comm );
}

#endif	// #if	defined(_IRIS_SUPPORT_GOOGLETEST)
