//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBitmap.h
 * @brief		bitmapNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBitmap_H_
#define INCG_IRIS_FndBitmap_H_

//======================================================================
// include
#include "FndImage.h"
#include "../../ml/iml_padding.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// define
#define BITMAP_FILEHEAD_TYPE	(0x4D42)	//	'BM'

//======================================================================
// enum

//======================================================================
// struct
#include "../../misc/iris_pushpack2.h"
//! BITMAP FILE wb_
typedef IRIS_PACKED struct tagBitmapFileHeader
{
    u16		bfType;
    u32		bfSize;
    u16		bfReserved1;
    u16		bfReserved2;
    u32		bfOffBits;
} BitmapFileHeader, BMPFILEHEADER, *LPBMPFILEHEADER;	//!< BITMAP FILE wb_
#include "../../misc/iris_poppack.h"

//! BITMAP Infomation wb_
typedef struct tagBitmapInfoHeader
{
    u32		biSize;				//!< \̃TCY
    s32		biWidth;			//!< 
    s32		biHeight;			//!< 
    u16		biPlanes;			//!< v[JEg
    u16		biBitCount;			//!< rbg[x
    u32		biCompression;		//!< k`
    u32		biSizeImage;		//!< C[WTCY @note 0 ̏ꍇ
    s32		biXPelsPerMeter;	//!< 
    s32		biYPelsPerMeter;	//!< 
    u32		biClrUsed;			//!< 
    u32		biClrImportant;		//!< 
} BitmapInfoHeader, BMPINFOHEADER, *LPBMPINFOHEADER;	//!< BITMAP Infomation wb_
//! BITMAP tH[}bg
typedef struct tagBitmapFormat
{
	LPBMPFILEHEADER	file;		//!< t@Cwb_
	LPBMPINFOHEADER	info;		//!< wb_
	u8*				data;		//!< f[^̈
	IrisRGBQUAD*	pallete;	//!< F
	u8*				pixel;		//!< sNZ
} BitmapFormat, BMPFMT, *LPBMPFMT;	//!< BITMAP tH[}bg

//======================================================================
// class
//!< rbg}bvbNX(Windows Bitmap Format)
class CBitmap : public IImage
{
public:
	static const size_t BMP_HEADSIZE	= sizeof( BMPFILEHEADER ) + sizeof( BMPINFOHEADER );
protected:
	bool	m_bAllocated;	//!< gŊmۂǂ
	IRIS_PADDING( iml::padding<sizeof(bool)>::size );
	BMPFMT	m_bmp;			//!< rbg}bv\
public:
	// RXgN^
	CBitmap(void);
	// fXgN^
	virtual ~CBitmap(void);

public:
	// t@C̐`FbN
	static bool	CheckFile(LPBMPFILEHEADER bfh, LPBMPINFOHEADER bih);
	virtual bool	CheckFile(void);
	// t@Cǂݍ
	template<typename CHARTYPE_>
	bool	ReadFile(const CHARTYPE_* lpFileName);
	virtual bool	ReadFileA(LPCSTR  lpFileName);
	virtual bool	ReadFileW(LPCWSTR lpFileName);
	// t@Cɏ
	template<typename CHARTYPE_>
	bool	WriteFile(const CHARTYPE_* lpFileName);
	virtual bool	WriteFileA(LPCSTR  lpFileName);
	virtual bool	WriteFileW(LPCWSTR lpFileName);

	// obt@ǂݍ
	virtual bool	ReadOnMemory(const void* lpBuffer);

protected:
	// obt@̊m
	virtual bool	Alloc(u32 size);
public:
	// obt@̉
	virtual void	Release(void);

public:
	// rbg}bv̍쐬
	virtual bool	Create(u16 nBitCount, s32 nWidth, s32 nHeight);
	// Rs[
	virtual bool	Duplicate(CBitmap& rBitmap);
	// Rs[
	virtual bool	Duplicate(IImage& rImage);
	// Rs[
	virtual bool	DuplicateOnMemory(const void* lpBuffer, u32 size);
	// wb_ɏ]ĕϊRs[
	virtual bool	Transfer(CBitmap& rBitmap);

public:
	// f[^Lǂ
	virtual bool	IsValid(void) const;
	// ΉĂBitCountǂ
	static	bool	IsSupportedBitCoount(u16 nBitCount);

public:
	// rbgJEg擾
	virtual u16				GetBitCount(void) const;
	// sNZ̎擾
	virtual void*			GetPixel(s32 x, s32 y) const;
	// sNZobt@̎擾
	virtual void*			GetPixel(void) const;
	// sNZJ[̎擾
	virtual bool			GetPixelRGBQUAD(s32 x, s32 y, IrisRGBQUAD& rgbq) const;
	// sNZJ[̐ݒ
	virtual bool			SetPixelRGBQUAD(s32 x, s32 y, const IrisRGBQUAD& rgbq);
	// pbg̎擾
	virtual IrisRGBQUAD*	GetPallete(u32 idx) const;
	// pbgobt@̎擾
	virtual IrisRGBQUAD*	GetPallete(void) const;
	// pbǧ擾
	virtual u32				GetPalleteNum(void) const;
	// pbg̃TCY擾
	virtual u32				GetPalleteSize(void) const;
	// C[Wf[^TCY擾
	virtual u32				GetImageSize(void) const;
	// C[Wf[^TCY擾
	static u32				GetImageSize(LPBMPINFOHEADER lpih);

public:
	// obt@ɓWJ
	virtual	bool			CreateImage  (void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	virtual	bool			CreateImage1 (void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	virtual	bool			CreateImage4 (void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	virtual	bool			CreateImage8 (void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	virtual	bool			CreateImage16(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	virtual	bool			CreateImage24(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	virtual	bool			CreateImage32(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;

public:
	// sNZJ[̎擾
	virtual bool			GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const;
	// sNZJ[̐ݒ
	virtual bool			SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba);

public:
	// FPx𒊏o
	static u8				GetLuminance(u8 r, u8 g, u8 b);

public:
	/// t@Cwb_[擾
	LPBMPFILEHEADER			GetFileHeader(void)		{ return m_bmp.file; }
	/// wb_[擾
	LPBMPINFOHEADER			GetInfoHeader(void)		{ return m_bmp.info; }
	/// 擾
	virtual s32				GetWidth(void)	const	{ return m_bmp.info->biWidth; }
	/// 擾
	virtual s32				GetHeight(void)	const	{ return m_bmp.info->biHeight >= 0 ? m_bmp.info->biHeight : -m_bmp.info->biHeight; }

public:
	// wb_̂ݍ쐬
	static bool		CreateHeader(LPBMPFMT pBmpFmt, u16 nBitCount, s32 nWidth, s32 nHeight);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
