//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBitmap555.h
 * @brief		bitmap555NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBitmap555_H_
#define INCG_IRIS_FndBitmap555_H_

//======================================================================
// include
#include "FndBitmap.h"

namespace iris {
namespace fnd
{

//======================================================================
// define
#define BITMAP_FILEHEAD_TYPE	(0x4D42)	//	'BM'

#define BI_BMP555				555L

//======================================================================
// enum

//======================================================================
// class
//!< rbg}bvbNX(Windows Bitmap Format)
class CBitmap555 : public CBitmap
{
public:
	// RXgN^
	CBitmap555(void);
	// fXgN^
	virtual ~CBitmap555(void);

public:
	// t@Cǂݍ
	virtual bool	ReadFileA(LPCSTR  lpFileName);
	virtual bool	ReadFileW(LPCWSTR lpFileName);

	// obt@ǂݍ
	virtual bool	ReadOnMemory(const void* lpBuffer);

public:
	// Rs[
	virtual bool	Duplicate(CBitmap& rBitmap);
	// Rs[
	virtual bool	DuplicateOnMemory(const void* lpBuffer, u32 size);

	// rbg}bvϊ
	virtual bool	Exchange(CBitmap& rBitmap, u32 color);

public:
	// sNZ̎擾
	virtual void*			GetPixel(s32 x, s32 y) const;
	// sNZobt@̎擾
	virtual void*			GetPixel(void) const;
	// sNZJ[̎擾
	virtual bool			GetPixelRGBQUAD(s32 x, s32 y, IrisRGBQUAD& rgbq) const;
	// sNZJ[̐ݒ
	virtual bool			SetPixelRGBQUAD(s32 x, s32 y, const IrisRGBQUAD& rgbq);
	// pbg̎擾
	virtual IrisRGBQUAD*	GetPallete(u32 idx) const;
	// pbgobt@̎擾
	virtual IrisRGBQUAD*	GetPallete(void) const;
	// pbǧ擾
	virtual u32				GetPalleteNum(void) const;
	// pbg̃TCY擾
	virtual u32				GetPalleteSize(void) const;

public:
	// sNZJ[̎擾
	virtual bool			GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const;
	// sNZJ[̐ݒ
	virtual bool			SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
