//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndColorExchange.h
 * @brief		J[tH[}bgϊNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndColorExchange_H_
#define INCG_IRIS_FndColorExchange_H_

//======================================================================
// include
#include "FndImage.h"
#include "FndColor.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// J[ϊe[uNX
class CColorExchange : public IIrisObject
{
public:
	typedef	void	(*PFN_COLOR_FORMAT_EXCHANGE)(u8* pDst, const u8* pSrc);	//!< ϊ֐^
private:
	PFN_COLOR_FORMAT_EXCHANGE	m_pfnExchange;

public:
	/// RXgN^
	CColorExchange(void) : m_pfnExchange(func_nullptr) {}
	CColorExchange(PFN_COLOR_FORMAT_EXCHANGE pfn) : m_pfnExchange(pfn) {}

public:
	/// ֐s
	void	operator ()(u8* pDst, const u8* pSrc)	{ if( m_pfnExchange != nullptr ) (m_pfnExchange)(pDst, pSrc); }

public:
	template<typename DST, typename SRC>
	static void	Exchange(DST* dst, const SRC* src)
	{
		*dst = *src;
	}

	template<typename DST, typename SRC>
	static void	Exchange(u8* dst, const u8* src)
	{
		Exchange(pointer_cast<DST*>(dst), pointer_cast<const SRC*>(src));
	}
public:
	// Fϊ֐̎擾
	static	PFN_COLOR_FORMAT_EXCHANGE		GetColorFormatExchange(IImage::PIXEL_FORMAT nSrcPixelFormat, IImage::PIXEL_FORMAT nDstPixelFormat, int* lpDstSize=nullptr);

	// Fϊ֐̎擾
	template<typename SRC>
	static	PFN_COLOR_FORMAT_EXCHANGE		GetColorFormatExchangeBySrc(IImage::PIXEL_FORMAT nDstPixelFormat, int* lpDstSize=nullptr)
	{
		static const PFN_COLOR_FORMAT_EXCHANGE list[IImage::PF_NUM] = {
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, SRC>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, SRC>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, SRC>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, SRC>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, SRC>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, SRC>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, SRC>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, SRC>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, SRC>,
		};
		if( lpDstSize != nullptr )	*lpDstSize = IImage::GetTexelSize(nDstPixelFormat);
		return list[nDstPixelFormat];
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
