//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndHLS.h
 * @brief		HLS t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndHLS_H_
#define INCG_IRIS_FndHLS_H_

//======================================================================
// include
#include "FndColor.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	HLS J[NX
*/
class CHLS : public IIrisObject
{
public:
	f32	m_h;	//!< F
	f32	m_l;	//!< Px
	f32 m_s;	//!< ʓx
public:
	/**
	 * @brief	RXgN^
	 * @{
	*/
	CHLS(void) : m_h(0), m_l(0), m_s(0) {}
	CHLS(f32 h, f32 l, f32 s) : m_h(y), m_l(u), m_s(v) {}
	CHLS(const IrisFColor& col) { cast_from_fcolor(col); }
	/**
	 * @}
	*/

public:
	operator IrisFColor (void)	const	{ IrisFColor col; cast_to_fcolor(col); return col; }

protected:
	/**
	 * @ϊ
	 * @{
	*/
	void	cast_from_fcolor(const IrisFColor& col)
	{
		f32 lo = min(col.r, col.g, col.b);
		f32 hi = max(col.r, col.g, col.b);
		f32 diff = (hi - lo);
		m_l = (hi + lo) / 2;
		if( diff > 0.0f )
		{
			if( m_l > 0.5f )
				m_s = diff / (2.0f - hi - lo);
			else
				m_s = diff / (hi + lo);

			f32 r = (hi - col.r) / diff;
			f32 g = (hi - col.g) / diff;
			f32 b = (hi - col.b) / diff;

			if( hi == col.r )
				m_h = 60.0f * (b - g);
			else if( hi == col.g )
				m_h = 60.0f * (r - b) + 120.0f;
			else
				m_h = 60.0f * (g - r) + 240.0f;
			if( m_h < 0.0f ) m_h += 360.0f;
		}
		else
		{
			m_h = m_s = 0.0f;
		}
	}
	void	cast_to_fcolor(IrisFColor& col) const
	{
		if( m_s > 0.0f )
		{
			f32 hi, lo;
			if( m_l > 0.5f )
			{
				hi = m_l * (1.0f - m_s) + m_s;
				lo = 2.0f * m_l - hi;
			}
			else
			{
				lo = m_l * (1.0f - m_s);
				hi = 2.0f * m_l - lo;
			}

			f32 diff = hi - lo;
			f32 c[3];
			f32 hh = m_h + 120.0f;
			if( hh >= 360.0f ) hh -= 360.0f;

			for( int i=0; i < 3; ++i, hh-=120.0f )
			{
				if( hh <   0.0f )	hh += 360.0f;
				if( hh <  60.0f )	c[i] = lo + diff * hh / 60.0f;
				if( hh < 180.0f )	c[i] = hi;
				if( hh < 240.0f )	c[i] = lo + diff * (240.0f - hh) / 60.0f;
				else				c[i] = lo;
			}
			col.r = c[0];
			col.g = c[1];
			col.b = c[2];
		}
		else
		{
			col.r = col.g = col.b = m_v;
		}
	}
	/**
	 * @}
	*/
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
