//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndImage.h
 * @brief		摜NXC^[tFCXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndImage_H_
#define INCG_IRIS_FndImage_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../ml/iml_constant.hpp"
//#include "../../c++0x/cpp0x_type_traits.hpp"
//#include "../../c++0x/cpp0x_enable_if.hpp"
#include "FndColor.h"
#include "FndLuminance.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// 摜NXC^[tFCX
class IImage : public IIrisObject
{
public:
	/// imageo̓sNZtH[}bg
	typedef enum
	{
		PF_RGBA8	= 0,	//!< RGBA8888
		PF_BGRA8,			//!< BGRA8888
		PF_RGB8,			//!< RGB888
		PF_BGR8,			//!< BGR888
		PF_RGBA4,			//!< RGBA4444
		PF_RGBA5551,		//!< RGBA5551
		PF_RGB565,			//!< RGB565
		PF_L8,				//!< LUMINANCE 8
		PF_LA8,				//!< LUMINANCE ALPHA 8
		PF_NUM,
		PF_INVALID	= 0xFF
	} PIXEL_FORMAT;

	/// pixel i[
	typedef enum
	{
		PPD_RIGHT		= 0x01,	//!< E獶
		PPD_TOP			= 0x02,	//!< ォ牺

		PPD_LEFT_TOP	= 0x0,	//!< E
		PPD_RIGHT_TOP	= 0x1,	//!< E獶
		PPD_LEFT_DOWN	= 0x2,	//!< ォE
		PPD_RIGHT_DOWN	= 0x3,	//!< Eォ獶

		PPD_MASK		= 0x3	//!< rbg}XN
	} PPD_TYPE;

	template<PIXEL_FORMAT FMT>
	class Format
	{
		template<PIXEL_FORMAT F, typename DMY>
		struct type_impl;

		template<typename DMY>
		struct type_impl<PF_RGBA8, DMY>		{ typedef CRGBA8888 type; };
		template<typename DMY>
		struct type_impl<PF_BGRA8, DMY>		{ typedef CBGRA8888 type; };
		template<typename DMY>
		struct type_impl<PF_RGB8, DMY>		{ typedef CRGB888 type; };
		template<typename DMY>
		struct type_impl<PF_BGR8, DMY>		{ typedef CBGR888 type; };
		template<typename DMY>
		struct type_impl<PF_RGBA4, DMY>		{ typedef CRGBA4444 type; };
		template<typename DMY>
		struct type_impl<PF_RGBA5551, DMY>	{ typedef CRGBA5551 type; };
		template<typename DMY>
		struct type_impl<PF_RGB565, DMY>	{ typedef CRGB565 type; };
		template<typename DMY>
		struct type_impl<PF_L8, DMY>		{ typedef CLuminance type; };
		template<typename DMY>
		struct type_impl<PF_LA8, DMY>		{ typedef CLuminanceAlpha type; };
	public:
		typedef typename type_impl<FMT, void>::type type;
		static const int size = type::BITCOUNT >> 3;
		static const int bitcount = type::BITCOUNT;
	};

public:
	/// RXgN^
	IImage(void)	{}
	/// fXgN^
	virtual ~IImage(void) {}

public:
	/// LȃC[Wǂ
	virtual bool	IsValid(void)	const = 0;
	/// ̎擾
	virtual s32		GetWidth(void)	const = 0;
	/// ̎擾
	virtual s32		GetHeight(void)	const = 0;

public:
	//! 1eNZTCY擾
	static 	int		GetTexelSize(PIXEL_FORMAT fmt)
	{
		switch( fmt )
		{
		case PF_RGBA8:
		case PF_BGRA8:
			return 4;
		case PF_RGB8:
		case PF_BGR8:
			return 3;
		case PF_L8:
			return 1;
		case PF_RGBA4:
		case PF_RGBA5551:
		case PF_RGB565:
		case PF_LA8:
			return 2;
		case PF_INVALID:
		default:
			return 0;
		}
	}

public:
	/// raw f[^ɕKvȃTCY擾
	s32					GetRawDataSize(PIXEL_FORMAT fmt, int nLineAlign=1)	const
	{
		return static_cast<s32>(GetHeight() * IRIS_RoundUpNB( GetWidth() * GetTexelSize(fmt), nLineAlign ));
	}

public:
	// Rs[
	virtual bool		Duplicate(IImage& /*rImage*/) { return false; }

public:
	/// sNZJ[̎擾
	virtual bool		GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const = 0;
	/// sNZJ[̐ݒ
	virtual bool		SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba) = 0;

public:
	// obt@ɓWJ
	virtual	bool		CreateImage(void* /*pBuffer*/, PIXEL_FORMAT /*nPixelFormat*/, int nLineAlign=1, int nOrder=PPD_LEFT_TOP) const
	{
		IRIS_UNUSED_VAR(nLineAlign);
		IRIS_UNUSED_VAR(nOrder);
		return false;
	}

};

}	// end of namespace wx
}	// end of namespace iris

#endif
