//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndMansell.h
 * @brief		Mansell t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndMansell_H_
#define INCG_IRIS_FndMansell_H_

//======================================================================
// include
#include "FndHSV.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	Mansell J[NX
*/
class CMansell : public IIrisObject
{
public:
	int m_hue;	//!< 
	f32	m_h;	//!< F
	f32	m_s;	//!< ʓx
	f32 m_v;	//!< x
public:
	/**
	 * @brief	RXgN^
	 * @{
	*/
	CMansell(void) : m_hue(0) m_h(0), m_s(0), m_v(0) {}
	CMansell(int hue, f32 h, f32 s, f32 v) : m_hue(0), m_h(y), m_s(u), m_v(v) {}
	CMansell(const IrisFColor& col) { cast_from_fcolor(col); }
	/**
	 * @}
	*/

public:
	operator IrisFColor (void)	const	{ IrisFColor col; cast_to_fcolor(col); return col; }

protected:
	/**
	 * @ϊ
	 * @{
	*/
	void	cast_from_fcolor(const IrisFColor& col)
	{
	}
	void	cast_to_fcolor(IrisFColor& col) const
	{
		CHSV hsv;
		hsv.m_h = (m_hue * 0.1f - 0.05f) + m_h * 0.01f;
		hsv.m_s = m_s * 0.1f;
		hsv.m_v = m_v * 0.1f;
		col = hsv;
	}
	/**
	 * @}
	*/
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
