//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndPng.cpp
 * @brief		png t@CNXt@C
 *
 * @note
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndPng_CPP_

//======================================================================
// include
#include "FndPng.h"
#include "FndColorExchange.h"

#ifdef _IRIS_SUPPORT_PNG

#include "../io/FndFile.h"
#include "../memory/FndMemory.h"
#include "../../iris_debug.h"

//======================================================================
// link
#if		defined(_WIN32) && defined(_MT)
#  if		(_IRIS_SUPPORT_PNG == IRIS_DYNAMIC_LIB)
#    define	PNG_LIBNAME_TYPE		""
#    define PNG_LIBNAME_MODE		""
#    define PNG_LIBNAME_VC			""
#    define PNG_OPTION				""
#  else
#    define	PNG_LIBNAME_TYPE		"_static_"
#    define PNG_LIBNAME_MODE		IRIS_LIB_MODE
#    define PNG_LIBNAME_VC			IRIS_LIB_VCVER
#    define PNG_LIBNAME_AMD64		IRIS_LIB_AMD64
#  endif

#  pragma comment( lib, "libpng" \
	PNG_LIBNAME_TYPE	\
	PNG_LIBNAME_MODE	\
	PNG_LIBNAME_VC		\
	PNG_LIBNAME_AMD64	\
	IRIS_LIB_POSTFIX	\
	".lib" )

#  pragma comment( lib, "zlib" \
	PNG_LIBNAME_TYPE	\
	PNG_LIBNAME_MODE	\
	PNG_LIBNAME_VC		\
	PNG_LIBNAME_AMD64	\
	IRIS_LIB_POSTFIX	\
	".lib" )

#endif

namespace iris {
namespace fnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPng::CPng(void)
: m_pBuffer(nullptr)
, m_Size(0)
, m_Width(0)
, m_Height(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPng::~CPng(void)
{
	Release();
}

/**********************************************************************//**
 *
 * t@Cǂݍ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
template<>
bool CPng::ReadFile<CHAR>(LPCSTR lpFileName)
{
	if( lpFileName == nullptr ) return false;
	CFile file;
	if( !file.OpenA(lpFileName, FOPEN_READ) ) return false;
	Release();

	u32 size = file.GetSize();
	Alloc(size, 0);
	if( m_pBuffer == nullptr ) return false;
	file.Read(m_pBuffer, size);
	if( !ReadFormat() )
	{
		Release();
		return false;
	}
	return true;
}
template<>
bool CPng::ReadFile<WCHAR>(LPCWSTR lpFileName)
{
	if( lpFileName == nullptr ) return false;
	CFile file;
	if( !file.OpenW(lpFileName, FOPEN_READ) ) return false;
	Release();

	u32 size = file.GetSize();
	Alloc(size, 0);
	if( m_pBuffer == nullptr ) return false;
	file.Read(m_pBuffer, size);
	if( !ReadFormat() )
	{
		Release();
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CPng::Release(void)
{
	Dealloc();
}

/**********************************************************************//**
 *
 * Rs[̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	png	=	Rs[png
 * @return	
*//***********************************************************************/
bool CPng::Duplicate(CPng& png)
{
	Release();

	u32 size = png.GetBufferSize();
	if( size == 0 ) return false;
	Alloc(size, 0);
	if( m_pBuffer == nullptr ) return false;
	memcpy(m_pBuffer, png.GetBuffer(), size);
	if( !ReadFormat() )
	{
		Release();
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * obt@ɓWJ
 *
 ----------------------------------------------------------------------
 * @param [out]	pBuffer			= o̓obt@
 * @param [in]	nPixelFormat	= pixeltH[}bg
 * @param [in]	nLineAlign		= 1sPʂ̃ACgoCg
 * @param [in]	nOrder			= sNZi[
 * @return	
*//***********************************************************************/
bool CPng::CreateImage(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign, int nOrder) const
{
	if( m_pBuffer == nullptr ) return false;
	if( pBuffer == nullptr ) return false;
	IRIS_ASSERT( nLineAlign > 0 );

	png_struct* png  = nullptr;
	png_info*	info = nullptr;
	png = png_create_read_struct(PNG_LIBPNG_VER_STRING, nullptr, nullptr, nullptr);
	if( png == nullptr ) return false;
	info = png_create_info_struct(png);
	if( info == nullptr )
	{
		png_destroy_read_struct(&png, &info, nullptr);
		return false;
	}
	u8* fp = m_pBuffer;
	png_set_read_fn(png, &fp, ReadCallbackFunc);

	png_read_info(png, info);

	png_uint_32 width, height;
	int bpp, ColorType;
	png_get_IHDR(png, info, &width, &height, &bpp, &ColorType, nullptr, nullptr, nullptr);

	if( png_get_valid(png, info, PNG_INFO_tRNS) )		png_set_expand(png);
	if( ColorType == PNG_COLOR_TYPE_PALETTE )			png_set_expand(png);
	if( ColorType == PNG_COLOR_TYPE_GRAY &&	bpp < 8 )	png_set_expand(png);
	if( ColorType == PNG_COLOR_TYPE_GRAY )				png_set_gray_to_rgb(png);
	if( bpp > 8 )										png_set_strip_16(png);
	if( ( ColorType & PNG_COLOR_MASK_ALPHA ) == 0 )		png_set_filler(png, 0xFF, PNG_FILLER_AFTER);


	u8* dst = (u8*)pBuffer;
	CColorExchange::PFN_COLOR_FORMAT_EXCHANGE pfnFmtExchange = func_nullptr;
	int pf_src_size = Format<PF_RGBA8>::size;
	int pf_size = 0;

#if 0
	PIXEL_FORMAT nSrcFormat = PF_RGBA8;
	if( nPixelFormat == PF_BGRA8 )
	{
		png_set_bgr(png);
		nSrcFormat = PF_BGRA8;
	}
	pfnFmtExchange = CColorExchange::GetColorFormatExchange( nSrcFormat, nPixelFormat, &pf_size);
#else
	pfnFmtExchange = CColorExchange::GetColorFormatExchange( PF_RGBA8, nPixelFormat, &pf_size);
#endif
	if( pfnFmtExchange == nullptr ) return false;

	u8* tmp_buf = (u8*)irisAlloc(m_Width*pf_src_size, 0);
	if( tmp_buf == nullptr )
	{
		png_destroy_read_struct(&png, &info, nullptr);
		return false;
	}

	int line_buf_size = IRIS_RoundUpNB(width * pf_size, nLineAlign);
	int nextx = pf_size;
	int nexty = line_buf_size;
	int offset = 0;
	u8* dsty = dst;
	if( nOrder & PPD_RIGHT )
	{
		nextx = -pf_size;
		offset = (width-1) * pf_size;
	}
	if( !(nOrder & PPD_TOP) )
	{
		nexty = -line_buf_size;
		dsty = dst + (height-1) * line_buf_size;
	}

	for( png_uint_32 y=0; y < height; ++y, dsty += nexty )
	{
		png_read_row(png, tmp_buf, nullptr);
		u8* col = tmp_buf;
		u8* dstx = dsty + offset;
		for( png_uint_32 x=0; x < width; ++x )
		{
			(*pfnFmtExchange)(dstx, col);
			col += pf_src_size;
			dstx += nextx;
		}
	}
	irisFree(tmp_buf);

	png_destroy_read_struct(&png, &info, nullptr);
	return true;
}

/**********************************************************************//**
 *
 * LȃC[Wǂ
 *
 ----------------------------------------------------------------------
 * @return	obt@AhX
*//***********************************************************************/
bool CPng::IsValid(void)	const
{
	return m_pBuffer != nullptr;
}

/**********************************************************************//**
 *
 * w̃sNZ̐F擾
 *
 ----------------------------------------------------------------------
 * @param [in]	x		= xW
 * @param [in]	y		= yW
 * @param [out]	rgba	= F
 * @return	
*//***********************************************************************/
bool CPng::GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const
{
	IRIS_UNUSED_VAR(x);
	IRIS_UNUSED_VAR(y);
	IRIS_UNUSED_VAR(rgba);
	IRIS_PRAGMA_MSG_TODO("Ή")
	return false;
}

/**********************************************************************//**
 *
 * w̃sNZ̐Fݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	x		= xW
 * @param [in]	y		= yW
 * @param [in]	rgba	= F
 * @return	
*//***********************************************************************/
bool CPng::SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba)
{
	IRIS_UNUSED_VAR(x);
	IRIS_UNUSED_VAR(y);
	IRIS_UNUSED_VAR(rgba);
	IRIS_PRAGMA_MSG_TODO("Ή")
	return false;
}

/**********************************************************************//**
 *
 * tH[}bg̓ǂݍ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CPng::ReadFormat(void)
{
	if( m_pBuffer == nullptr ) return false;
	if( png_check_sig(m_pBuffer, m_Size) == 0 ) return false;

	png_struct* png  = nullptr;
	png_info*	info = nullptr;
	png = png_create_read_struct(PNG_LIBPNG_VER_STRING, nullptr, nullptr, nullptr);
	if( png == nullptr ) return false;
	info = png_create_info_struct(png);
	if( info == nullptr )
	{
		png_destroy_read_struct(&png, &info, nullptr);
		return false;
	}

	u8* fp = m_pBuffer;
	png_set_read_fn(png, &fp, ReadCallbackFunc);

	png_read_info(png, info);

	int bpp, color;
	png_get_IHDR(png, info, &m_Width, &m_Height, &bpp, &color, nullptr, nullptr, nullptr);

	png_destroy_read_struct(&png, &info, nullptr);
	return true;
}

/**********************************************************************//**
 *
 * obt@̃m
 *
 ----------------------------------------------------------------------
 * @param [in]	size	= TCY
 * @param [in]	arg		= 
*//***********************************************************************/
void CPng::Alloc(u32 size, s32 arg)
{
	Dealloc();
	m_pBuffer = static_cast<u8*>(irisAlloc(size, arg));
	m_Size = size;
}

/**********************************************************************//**
 *
 * obt@̃
 *
*//***********************************************************************/
void CPng::Dealloc(void)
{
	if( m_pBuffer != nullptr )
	{
		irisFree(m_pBuffer);
		m_pBuffer = nullptr;
		m_Size = 0;
	}
}

/**********************************************************************//**
 *
 * pngf[^ǂݎR[obN֐
 *
 ----------------------------------------------------------------------
 * @param [in]	lpPng		= png_structp
 * @param [in]	lpBuffer	= i[obt@
 * @param [in]	size		= f[^TCY
*//***********************************************************************/
void CPng::ReadCallbackFunc(png_structp lpPng, png_bytep lpBuffer, png_size_t size)
{
	u8** pp = (u8**)png_get_io_ptr(lpPng);
	memcpy(lpBuffer, *pp, size);
	*pp += size;
}

}	// end of namespace fnd
}	// end of namespace iris

#endif
