//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndYUVPack.h
 * @brief		YUVPack t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndYUVPack_H_
#define INCG_IRIS_FndYUVPack_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// struct
/**
 * @brief	U Y V Y
*/
typedef struct tagUYVY_PACK
{
	u8 u0, y0, v0, y1;
} UYVY_PACK;

/**
 * @brief	Y U Y V
*/
typedef struct tagYUV422_PACK
{
	u8 y0, u0, y1, v0;
} YUV422_PACK;

/**
 * @brief	Y V Y U
*/
typedef struct tagYVYU_PACK
{
	u8 y0, v0, y1, u0;
} YVYU_PACK;

//======================================================================
// class
/**
 * @brief	YUV 422
 * @tparam	YUV422PACK_	: pbN^Cv
*/
template<typename YUV422PACK_>
class CYUV422Pack : public IIrisObject
{
public:
	typedef YUV422PACK_	pack_t;
private:
	pack_t	m_Pack;

public:
	static int	kPixelCount = 2;
public:
	/**
	 * @brief	pbNێĂsNZ
	 * @return	sNZ
	*/
	int		GetCount(void)		const	{ return kPixelCount; }

	/**
	 * @biref	pbNYUV擾
	 * @tparam	󂯎 YUV NX
	 * @param [in]	yuv		= yuv NX
	 * @param [in]	index	= CfbNX
	*/
	template<typename CYUV>
	void	GetYUV(CYUV& yuv, int index)	const
	{
		yuv.u(m_Pack.u0);
		yuv.y(index == 0 ? m_Pack.y0 : m_Pack.y1);
		yuv.u(m_Pack.v0);
	}
	/**
	 * @biref	pbNYUVݒ
	 * @tparam	󂯎 YUV NX
	 * @param [in]	yuv		= yuv NX
	 * @param [in]	index	= CfbNX
	*/
	template<typename CYUV>
	void	SetYUV(CYUV& yuv, int index)
	{
		m_Pack.u0 = yuv.u();
		index == 0 ? m_Pack.y0 = yuv.y() : m_Pack.y1 = yuv.y();
		m_Pack.v0 = yuv.v();
	}
};

/**
 * @brief	YUV 411
*/
class CYUV411Pack : public IIrisObject
{
	struct IYU1
	{
		u8 u0, y0, y1, v0, y2, y3;
	};
public:
	typedef IYU1	pack_t;
private:
	pack_t	m_Pack;

public:
	static int	kPixelCount = 4;

public:
	/**
	 * @brief	pbNێĂsNZ
	 * @return	sNZ
	*/
	int		GetCount(void)		const	{ return kPixelCount; }

	/**
	 * @biref	pbNYUV擾
	 * @tparam	󂯎 YUV NX
	 * @param [in]	yuv		= yuv NX
	 * @param [in]	index	= CfbNX
	*/
	template<typename CYUV>
	void	GetYUV(CYUV& yuv, int index)	const
	{
		yuv.u(m_Pack.u0);
		u8* py = (index&2) == 0 ? &m_Pack.y0 : &m_Pack.y1;
		yuv.y(*(py + (index&1)));
		yuv.u(m_Pack.v0);
	}
	/**
	 * @biref	pbNYUVݒ
	 * @tparam	󂯎 YUV NX
	 * @param [in]	yuv		= yuv NX
	 * @param [in]	index	= CfbNX
	*/
	template<typename CYUV>
	void	SetYUV(CYUV& yuv, int index)
	{
		m_Pack.u0 = yuv.u();
		u8* py = (index&2) == 0 ? &m_Pack.y0 : &m_Pack.y1;
		*(py + (index&1)) = yuv.y();
		m_Pack.v0 = yuv.v();
	}
};

/**
 * @brief	YUV 444
*/
class CYUV444Pack : public IIrisObject
{
	struct IYU2
	{
		u8 u0, y0, v0;
	};
public:
	typedef IYU1	pack_t;
private:
	pack_t	m_Pack;

public:
	static int	kPixelCount = 1;

public:
	/**
	 * @brief	pbNێĂsNZ
	 * @return	sNZ
	*/
	int		GetCount(void)		const	{ return kPixelCount; }

	/**
	 * @biref	pbNYUV擾
	 * @tparam	󂯎 YUV NX
	 * @param [in]	yuv		= yuv NX
	 * @param [in]	index	= CfbNX
	*/
	template<typename CYUV>
	void	GetYUV(CYUV& yuv, int index)	const
	{
		yuv.u(m_Pack.u0);
		yuv.y(m_Pack.y0);
		yuv.u(m_Pack.v0);
	}
	/**
	 * @biref	pbNYUVݒ
	 * @tparam	󂯎 YUV NX
	 * @param [in]	yuv		= yuv NX
	 * @param [in]	index	= CfbNX
	*/
	template<typename CYUV>
	void	SetYUV(CYUV& yuv, int index)
	{
		m_Pack.u0 = yuv.u();
		m_Pack.y0 = yuv.y();
		m_Pack.v0 = yuv.v();
	}
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
