//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFile.cpp
 * @brief		FILENXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndFile_CPP_

//======================================================================
// include
#include "FndFile.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
// CFile
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFile::CFile(void)
: m_fp(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFile::~CFile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * ֘At
 *
 ----------------------------------------------------------------------
 * @param [in]	fp	= t@C|C^
 * @return	
*//***********************************************************************/
bool CFile::Attach(FILE* fp)
{
	if( m_fp != nullptr || fp == nullptr ) return false;
	m_fp = fp;
	return true;
}

/**********************************************************************//**
 *
 * ֘At
 *
 ----------------------------------------------------------------------
 * @return	ȑÕt@C|C^
*//***********************************************************************/
FILE* CFile::Detach(void)
{
	FILE* pre = m_fp;
	m_fp = nullptr;
	return pre;
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFileName	= t@C
 * @param [in]	mode		= [h
 * @return	
*//***********************************************************************/
bool CFile::Open (LPCTSTR lpFileName, LPCTSTR mode)
{
#ifdef UNICODE
	return OpenW(lpFileName, mode);
#else
	return OpenA(lpFileName, mode);
#endif
}
/// CFile::Open Q
bool CFile::OpenA(LPCSTR  lpFileName, LPCSTR  mode)
{
	if( !Close() ) return false;	// CloseɎs
#if	defined(IRIS_MWERKS)
	IRIS_PRAGMA_MSG_TODO("Ή");
	IRIS_UNUSED_VARIABLE(lpFileName);
	IRIS_UNUSED_VARIABLE(mode);
#else
	IRIS_PRAGMA_WARNING_DISABLE(IRIS_MSC, 4996)
	fopen_s(&m_fp, lpFileName, mode);
	IRIS_PRAGMA_WARNING_DEFAULT(IRIS_MSC, 4996)
#endif
	if( m_fp == nullptr ) return false;
	return true;
}
/// CFile::Open Q
bool CFile::OpenW(LPCWSTR lpFileName, LPCWSTR mode)
{
#if		defined(_WIN32)
	if( !Close() ) return false;	// CloseɎs
	_wfopen_s(&m_fp, lpFileName, mode);
	if( m_fp == nullptr ) return false;
	return true;
#else
	IRIS_UNUSED_VARIABLE(lpFileName);
	IRIS_UNUSED_VARIABLE(mode);
	return false;
#endif
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 ----------------------------------------------------------------------
 * @param [out]	buf		= o̓obt@
 * @param [in]	size	= o̓obt@TCY
 * @param [in]	n		= y[W
 * @return	ǂݍ݃TCY
*//***********************************************************************/
u32 CFile::Read(void* buf, u32 size, u32 n)
{
	if( m_fp == nullptr ) return 0;
	return static_cast<u32>(fread(buf, size, n, m_fp) * size);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	buf		= ̓obt@
 * @param [in]	size	= ̓obt@TCY
 * @param [in]	n		= y[W
 * @return	݃TCY
*//***********************************************************************/
u32 CFile::Write(const void* buf, u32 size, u32 n)
{
	if( m_fp == nullptr ) return 0;
	return static_cast<u32>(fwrite(buf, size, n, m_fp) * size);
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFileName	= t@C
 * @param [in]	mode		= [h
 * @return	
*//***********************************************************************/
/// CFile::Open Q
bool CFile::OpenA(LPCSTR  lpFileName, u32 mode)
{
	int idx=0;
	CHAR md[4] = "";
	if( mode & FOPEN_READ  )
	{
		md[idx++] = 'r';
	}
	if( mode & FOPEN_WRITE )
	{
		md[idx++] = 'w';
	}
	//if( mode & FOPEN_READLOCK  ) {}
	//if( mode & FOPEN_WRITELOCK ) {}
	//if( mode & FOPEN_CREATE )	{}
	md[idx++] = 'b';
	return OpenA(lpFileName, md);
}
/// CFile::Open Q
bool CFile::OpenW(LPCWSTR lpFileName, u32 mode)
{
	int idx=0;
	WCHAR md[4] = L"";
	if( mode & FOPEN_READ  )
	{
		md[idx++] = L'r';
	}
	if( mode & FOPEN_WRITE )
	{
		md[idx++] = L'w';
	}
	//if( mode & FOPEN_READLOCK  ) {}
	//if( mode & FOPEN_WRITELOCK ) {}
	//if( mode & FOPEN_CREATE )	{}
	md[idx++] = L'b';
	return OpenW(lpFileName, md);
}

/**********************************************************************//**
 *
 * JĂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CFile::IsOpen(void)	const
{
	return (m_fp != nullptr);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CFile::Close(void)
{
	if( m_fp == nullptr ) return true;
	FILE* fp = m_fp;
	if( fclose(fp) != 0 ) return false;
	m_fp = nullptr;
	return true;
}

/**********************************************************************//**
 *
 * Seek
 *
 ----------------------------------------------------------------------
 * @param [in]	offset	= ItZbg
 * @param [in]	origin	= vZN_
 * @return	
*//***********************************************************************/
bool CFile::Seek(long offset, int origin)
{
	if( m_fp == nullptr ) return false;
	return fseek(m_fp, offset, origin) != 0;
}

/**********************************************************************//**
 *
 * ݂̃t@C|C^ʒu̎擾
 *
 ----------------------------------------------------------------------
 * @return	݂̃t@C|C^ʒu
*//***********************************************************************/
s32 CFile::Tell(void)	const
{
	if( m_fp == nullptr ) return 0;
	return ftell(m_fp);
}

/**********************************************************************//**
 *
 * t@CTCY擾
 *
 ----------------------------------------------------------------------
 * @return	t@CTCY
*//***********************************************************************/
u32 CFile::GetSize(void)	const
{
	if( m_fp == nullptr ) return 0;
	long before = ftell(m_fp);
	fseek(m_fp, 0, SEEK_SET);
	long offset = ftell(m_fp);
	fseek(m_fp, 0, SEEK_END);
	u32 size = static_cast<u32>(ftell(m_fp) - offset);
	fseek(m_fp, before, SEEK_SET);
	return size;
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 ----------------------------------------------------------------------
 * @param [out]	buf		= o̓obt@
 * @param [in]	size	= o̓obt@TCY
 * @param [in]	n		= y[W
 * @return	ǂݍ݃TCY
*//***********************************************************************/
u32 CFile::Read(void* buf, u32 size)
{
	return Read(buf, size, 1);
}

/**********************************************************************//**
 *
 * ǂݍ݁i񓯊j
 *
 ----------------------------------------------------------------------
 * @param [out]	buf		= o̓obt@
 * @param [in]	size	= o̓obt@TCY
 * @param [in]	n		= y[W
 * @return	ǂݍ݃TCY
*//***********************************************************************/
u32 CFile::ReadAsync(void* buf, u32 size)
{
	return Read(buf, size, 1);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	buf		= ̓obt@
 * @param [in]	size	= ̓obt@TCY
 * @param [in]	n		= y[W
 * @return	݃TCY
*//***********************************************************************/
u32	CFile::Write(const void* buf, u32 size)
{
	return Write(buf, size, 1);
}

/**********************************************************************//**
 *
 * ݁i񓯊j
 *
 ----------------------------------------------------------------------
 * @param [in]	buf		= ̓obt@
 * @param [in]	size	= ̓obt@TCY
 * @param [in]	n		= y[W
 * @return	݃TCY
*//***********************************************************************/
u32 CFile::WriteAsync(const void* buf, u32 size)
{
	return Write(buf, size, 1);
}

/**********************************************************************//**
 *
 * 1sǂݍ
 *
 ----------------------------------------------------------------------
 * @param [out]	buf		= o̓obt@
 * @param [in]	size	= o̓obt@TCY
 * @retval	nullptr	= EOF
*//***********************************************************************/
LPTSTR CFile::ReadLine (LPTSTR buf, int size)
{
#ifdef UNICODE
	return ReadLineW(buf, size);
#else
	return ReadLineA(buf, size);
#endif
}
/// CFile::ReadLine Q
LPSTR  CFile::ReadLineA(LPSTR  buf, int size)
{
	if( m_fp == nullptr ) return nullptr;
	return fgets(buf, size, m_fp);
}
LPWSTR CFile::ReadLineW(LPWSTR buf, int size)
{
	if( m_fp == nullptr ) return nullptr;
	return fgetws(buf, size, m_fp);
}

}	// end of namespace mac
}	// end of namespace iris
