//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndIStream.h
 * @brief		stream C^[tFCX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndIStream_H_
#define INCG_IRIS_FndIStream_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
//! Stream C^[tFCX
class IStream : private INonCopyable<IStream>
{
public:
	// RXgN^
	IStream(void)			{}
	// fXgN^
	virtual ~IStream(void)	{}
public:
	/**
	 * seek
	 * @param [in]	offset	= ItZbg
	 * @param [in]	origin	= vZ@
	 * @return	
	*/
	virtual bool	Seek(long offset, int origin)	= 0;
	/**
	 * tell
	 * @return	݂̈ʒu
	*/
	virtual s32		Tell(void)		const	= 0;

	/**
	 * ǂݍ
	 * @param [out]	buf		= o̓obt@
	 * @param [in]	size	= o̓obt@TCY
	 * @return	ǂݍ݃TCY
	*/
	virtual u32		Read(void* buf, u32 size)			= 0;
	/**
	 * 
	 * @param [in]	buf		= ̓obt@
	 * @param [in]	size	= ̓obt@TCY
	 * @return	݃TCY
	*/
	virtual u32		Write(const void* buf, u32 size)	= 0;
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
