//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndMemFunc.c
 * @brief		֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndMemFunc_C_

//======================================================================
// include
#include "FndMemFunc.h"

//======================================================================
// function

/**
 * @brief	Rs[(8bit)
 * @param [out]	pDst	= o̓obt@
 * @param [in]	pSrc	= ̓obt@
 * @param [in]	nSize	= ̓obt@
 * @return	o̓obt@
*/
void* irisCpuCopy8(void* pDst, const void* pSrc, IrisU32 nSize)
{
	IrisU8* p = (IrisU8*)pDst;
	const IrisU8* q = (const IrisU8*)pSrc;
	if( nSize <= 0 ) return pDst;
	while(nSize--)
	{
		*p++ = *q++;
	}
	return pDst;
}

/**
 * @brief	Rs[(16bit)
 * @param [out]	pDst	= o̓obt@
 * @param [in]	pSrc	= ̓obt@
 * @param [in]	nSize	= ̓obt@
 * @return	o̓obt@
*/
void* irisCpuCopy16(void* pDst, const void* pSrc, IrisU32 nSize)
{
	IrisU16* p1 = (IrisU16*)(pDst);
	const IrisU16* q1 = (const IrisU16*)(pSrc);
	if( nSize <= 0 ) return pDst;
	while(nSize >= 2)
	{
		*p1++ = *q1++;
		nSize -= 2;
	}
	if( nSize > 0 )
	{
		IrisU8* p2 = (IrisU8*)(p1);
		const IrisU8* q2 = (const IrisU8*)(q1);
		*p2 = *q2;
	}
	return pDst;
}

/**
 * @brief	Rs[(32bit)
 * @param [out]	pDst	= o̓obt@
 * @param [in]	pSrc	= ̓obt@
 * @param [in]	nSize	= ̓obt@
 * @return	o̓obt@
*/
void* irisCpuCopy32(void* pDst, const void* pSrc, IrisU32 nSize)
{
	IrisU32* p1 = (IrisU32*)(pDst);
	const IrisU32* q1 = (const IrisU32*)(pSrc);
	if( nSize <= 0 ) return pDst;
	while(nSize >= 4)
	{
		*p1++ = *q1++;
		nSize -= 4;
	}
	if( nSize > 0 )
	{
		IrisU8* p2 = (IrisU8*)(p1);
		const IrisU8* q2 = (const IrisU8*)(q1);
		while(nSize--)
		{
			*p2++ = *q2++;
		}
	}
	return pDst;
}

/**
 * @brief	Rs[(32bit)
 * @param [out]	pDst	= o̓obt@
 * @param [in]	pSrc	= ̓obt@
 * @param [in]	nSize	= ̓obt@
 * @return	o̓obt@
*/
void* irisCpuCopy32Fast(void* pDst, const void* pSrc, IrisU32 nSize)
{
	IrisU32* p = (IrisU32*)(pDst);
	const IrisU32* q = (const IrisU32*)(pSrc);
	IRIS_ASSERT( nSize );
	IRIS_ASSERT( nSize & 3 );
	nSize >>= 2;
	while(nSize--)
	{
		*p++ = *q++;
	}
	return pDst;
}

/**
 * @brief	Rs[(64bit)
 * @param [out]	pDst	= o̓obt@
 * @param [in]	pSrc	= ̓obt@
 * @param [in]	nSize	= ̓obt@
 * @return	o̓obt@
*/
void* irisCpuCopy64(void* pDst, const void* pSrc, IrisU32 nSize)
{
	IrisU64* p1 = (IrisU64*)(pDst);
	const IrisU64* q1 = (const IrisU64*)(pSrc);
	if( nSize <= 0 ) return pDst;
	while(nSize >= 8)
	{
		*p1++ = *q1++;
		nSize -= 8;
	}
	if( nSize > 0 )
	{
		IrisU8* p2 = (IrisU8*)(p1);
		const IrisU8* q2 = (const IrisU8*)(q1);
		while(nSize--)
		{
			*p2++ = *q2++;
		}
	}
	return pDst;
}

/**
 * @brief	Rs[(GfBAlRs[)
 * @param [out]	pDst	= o̓obt@(8bit)
 * @param [in]	pSrc	= ̓obt@
 * @param [in]	nSize	= ̓obt@
 * @param [in]	nAlign	= ̓obt@̃ACg
 * @return	o̓obt@
*/
void* irisCpuCopyAlign(void* pDst, const void* pSrc, IrisU32 nSize, IrisU32 nAlign)
{
#ifdef __BIG_ENDIAN__
	IRIS_UNUSED_VARIABLE(nAlign)
	irisCpuCopy8(pDst, pSrc, nSize);
#else
	IrisU8* p = (IrisU8*)(pDst);
	const IrisU8* q = (const IrisU8*)(pSrc);
	IrisU32 i, j, sz;
	IRIS_ASSERT( nAlign );
	IRIS_ASSERT( (nSize % nAlign) == 0 );
	for( i=0, sz=nSize/nAlign; i < sz; ++i, q+=nAlign )
	{
		for( j=nAlign; j > 0; --j )
		{
			*p++ = *(q + j-1);
		}
	}
#endif
	return pDst;
}

/**
 * @brief	Ɏw̒l(8bit)
 * @param [out]	pDst	= o̓obt@
 * @param [in]	nValue	= ͒l
 * @param [in]	nSize	= ̓obt@
 * @return	o̓obt@
*/
void* irisCpuClear8(void* pDst, IrisS32 nValue, IrisU32 nSize)
{
	IrisU8* p = (IrisU8*)(pDst);
	IrisU8 code = (IrisU8)(nValue);
	if( nSize <= 0 ) return pDst;
	while(nSize--)
	{
		*p++ = code;
	}
	return pDst;
}

/**
 * @brief	Ɏw̒l(16bit)
 * @param [out]	pDst	= o̓obt@
 * @param [in]	nValue	= ͒l
 * @param [in]	nSize	= ̓obt@
 * @return	o̓obt@
*/
void* irisCpuClear16(void* pDst, IrisS32 nValue, IrisU32 nSize)
{
	IrisU16* p = (IrisU16*)pDst;
	IrisU16 code = (IrisU16)nValue;
	IRIS_ASSERT((nSize & 1) == 0);
	if( nSize <= 0 ) return pDst;
	nSize>>=1;
	while(nSize--)
	{
		*p++ = code;
	}
	return pDst;
}

/**
 * @brief	Ɏw̒l(16bit)
 * @param [out]	pDst	= o̓obt@
 * @param [in]	nValue	= ͒l
 * @param [in]	nSize	= ̓obt@
 * @return	o̓obt@
*/
void* irisCpuClear32(void* pDst, IrisS32 nValue, IrisU32 nSize)
{
	IrisU32* p = (IrisU32*)(pDst);
	IrisU32 code = (IrisU32)(nValue);
	IRIS_ASSERT((nSize & 3) == 0);
	if( nSize <= 0 ) return pDst;
	nSize>>=2;
	while(nSize--)
	{
		*p++ = code;
	}
	return pDst;
}
