//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndPad.h
 * @brief		pad C^[tFCXNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndPad_H_
#define INCG_IRIS_FndPad_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../ml/iml_padding.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	pbhC^[tFCX
*/
class IPad : public IIrisObject
{
public:
	virtual void	Update(void) = 0;
	virtual void	Clear(void) = 0;
};

/**
 * @brief	pbhC^[tFCXNX
 * @tparam _TN	= {^^
*/
template<typename _TN>
class IButtonPad : public IPad
{
	typedef _TN	value_type;

protected:
	u16			m_Cnt;			//!< s[gJE^
	s8			m_RptCnt;		//!< s[gJE^NAl
	s8			m_RptCntFirst;	//!< s[gJE^NAl()
	value_type	m_Rpt;			//!< s[g

	IRIS_PADDING(iml::padding<sizeof(value_type)>::size);

public:
	/// RXgN^
	IButtonPad(void)	: m_Cnt(0), m_RptCnt(4), m_RptCntFirst(6), m_Rpt(0)	{}
public:
	virtual	value_type	GetHold(void)		const	= 0;				//!< x^擾
	virtual	value_type	GetTrig(void)		const	= 0;				//!< gK[擾
	virtual	value_type	GetRelease(void)	const	= 0;				//!< [X擾
	virtual	value_type	GetRept(void)		const	{ return m_Rpt; }	//!< s[g擾

	s8			GetRepeatCount(void)		const	{ return m_RptCnt; }
	void		SetRepeatCount(s8 cnt)				{ m_RptCnt = cnt; }
	s8			GetRepeatCountFirst(void)	const	{ return m_RptCntFirst; }
	void		SetRepeatCountFirst(s8 cnt)			{ m_RptCntFirst = cnt; }

public:
	/// XV
	virtual void	Update(void)
	{
		value_type old = GetHold();
		PadRead();
		value_type pad = GetHold();
		value_type trg = GetTrig();
		m_Rpt	= 0;
		if( pad ^ old ) { m_Cnt = 0; return; }
		if( m_Cnt & 0x8000 )
		{
			// Qڈȍ~
			++m_Cnt;
			if( (s8)(m_Cnt & 0xFF) > m_RptCnt )
			{
				m_Cnt = 0x8000;
				m_Rpt = pad;
			}
		}
		else
		{
			// 
			// ŏ݂͔̉
			if( m_Cnt ) { m_Rpt = trg; }
			else
			{
				++m_Cnt;
				if( (s8)(m_Cnt & 0xFF) > m_RptCntFirst )
				{
					m_Cnt = 0x8000;
					m_Rpt = pad;
				}
			}
		}
	}
	/// NA
	virtual void	Clear(void)
	{
		m_Rpt = m_Cnt = 0;
	}

protected:
	/// pbhǂݍ
	virtual	void	PadRead(void)	= 0;
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
