//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndPhase.h
 * @brief		tFCYNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndPhase_H_
#define INCG_IRIS_FndPhase_H_

//======================================================================
// include
#include "../container/FndList.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// tFCYC^[tFCX
class IPhase : public CListNodeBase
{
public:
	// fXgN^
	virtual ~IPhase(void)	{}
public:
	virtual	void	Start(void)		= 0;	//!< Jn
	virtual	void	Finish(void)	= 0;	//!< I
	virtual	void	Suspend(void)	= 0;	//!< x~
	virtual	void	Resume(void)	= 0;	//!< A
};

/// tFCYǗNX
class CPhaseCore : private INonCopyable<CPhaseCore>
{
protected:
	typedef enum ePHASE_CMD
	{
		CMD_NONE	= 0,	//!< ɂȂ
		CMD_PUSH	= 1,	//!< push
		CMD_NEXT	= 2,	//!< next
		CMD_SHIFT	= 3,	//!< shift
		CMD_POP		= 4,	//!< pop
		CMD_TERM
	} ePHASE_CMD;
	typedef struct tagPHASE_INFO
	{
		ePHASE_CMD	cmd;
		IPhase*		phase;
		tagPHASE_INFO(void) : cmd(CMD_NONE), phase(nullptr) {}
		tagPHASE_INFO(ePHASE_CMD c, IPhase* p) : cmd(c), phase(p) {}
	} PHASE_INFO;

	typedef CList<IPhase>	CPhaseList;
protected:
	PHASE_INFO	m_Info;
	CPhaseList	m_List;

public:
	// ݂̃tFCY~ĐVtFCYJn
	void	Push(IPhase* pPhase)
	{
		IRIS_ASSERT(m_Info.cmd == CMD_NONE && "don't permit multiplex command.");
		m_Info.cmd	 = CMD_PUSH;
		m_Info.phase = pPhase;
	}
	// ݂̃tFCYIĐVtFCYJn
	void	Next(IPhase* pPhase)
	{
		IRIS_ASSERT(m_Info.cmd == CMD_NONE && "don't permit multiplex command.");
		m_Info.cmd	 = CMD_NEXT;
		m_Info.phase = pPhase;
	}
	// ׂẴtFCYIĐVtFCYƓւ
	void	Shift(IPhase* pPhase)
	{
		IRIS_ASSERT(m_Info.cmd == CMD_NONE && "don't permit multiplex command.");
		m_Info.cmd	 = CMD_SHIFT;
		m_Info.phase = pPhase;
	}
	// ݂̃tFCYI
	void	Pop(void)
	{
		IRIS_ASSERT(m_Info.cmd == CMD_NONE && "don't permit multiplex command.");
		m_Info.cmd	 = CMD_POP;
		m_Info.phase = nullptr;
	}

public:
	// tFCY̍XV
	void	Commit(void)
	{
		if( m_Info.cmd == CMD_NONE ) return;
		switch( m_Info.cmd )
		{
		case CMD_PUSH:	// ݂̃tFCY~ĐVtFCYJn
			if( !m_List.empty() ) m_List.back()->Suspend();
			m_List.push_back(m_Info.phase);
			m_Info.phase->Start();
			break;
		case CMD_NEXT:	// ݂̃tFCYIĐVtFCYJn
			if( !m_List.empty() )
			{
				IPhase* p = m_List.back();
				p->Finish();
				m_List.pop_back();
				DeletePhase(p);
			}
			m_List.push_back(m_Info.phase);
			m_Info.phase->Start();
			break;
		case CMD_SHIFT:	// ׂẴtFCYIĐVtFCYƓւ
			while( !m_List.empty() )
			{
				IPhase* p = m_List.back();
				p->Finish();
				m_List.pop_back();
				DeletePhase(p);
				if( !m_List.empty() ) m_List.back()->Resume();
			}
			m_List.push_back(m_Info.phase);
			m_Info.phase->Start();
			break;
		case CMD_POP:	// ݂̃tFCYI
			if( !m_List.empty() )
			{
				IPhase* p = m_List.back();
				p->Finish();
				m_List.pop_back();
				DeletePhase(p);
			}
			if( !m_List.empty() )
			{
				m_List.back()->Resume();
			}
			break;
		}
		m_Info.cmd	 = CMD_NONE;
		m_Info.phase = nullptr;
	}

public:
	// 폜R}h
	virtual	void	DeletePhase(IPhase*)	{}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
