//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndPhaseFactory.h
 * @brief		tFCYNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndPhaseFactory_H_
#define INCG_IRIS_FndPhaseFactory_H_

//======================================================================
// include
#include "../container/tree/FndRedBlackTree.h"
#include "FndPhase.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// tF[Yt@NgNXC^[tFCX
class IPhaseFuctory : public CRBTreeNodeBase
{
	typedef CRBTree<IPhaseFuctory>	_Mytree;
public:
	/// RXgN^
	IPhaseFuctory(void)
	{
		GetRegister().insert(this);
	}
	/// fXgN^
	virtual ~IPhaseFuctory(void)
	{
		GetRegister().erase(this);
	}

public:
	/// tF[Y̍쐬
	virtual	IPhase*		Create(s32 phaseID, void* lpUser) = 0;
	/// tF[YID̎擾
	virtual s32			GetPhaseID(void) const	= 0;

public:
	bool	operator < (const IPhaseFuctory& rhs) const
	{
		return GetPhaseID() < rhs.GetPhaseID();
	}

	bool	operator < (s32 id) const
	{
		return GetPhaseID() < id;
	}

	bool	operator == (s32 id) const
	{
		return GetPhaseID() == id;
	}

public:
	// t@Ng[̎擾
	static	IPhaseFuctory*	GetFactory(s32 id)	{ return &GetRegister().search(id); }
public:
	static	_Mytree&		GetRegister(void)	{ static _Mytree tree; return tree; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
