//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFps.cpp
 * @brief		FPSNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndFps_CPP_

//======================================================================
// include
#include "FndFps.h"

namespace iris {
namespace fnd
{

//======================================================================
// variable
CFps		CFps::s_Fps;
const xf32	CFps::BASE_FPS = XF32_CONST(60.0f);

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFps::CFps(void)
{
	SetFPS(BASE_FPS);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
//CFps::~CFps(void)
//{
//}

/**********************************************************************//**
 *
 * fps̐ݒ
 *
 ----------------------------------------------------------------------
 * @param	fps	= 60Ŋ؂鐔
*//***********************************************************************/
void CFps::SetFPS(xf32 fps)
{
	if( fps >= BASE_FPS ) { fps = BASE_FPS; }
	int	vpf = XF_XF32_TO_S32( XF32_Div(BASE_FPS, fps) );
	m_fps = BASE_FPS / vpf;
	m_spf = XF32_Div( XF32_ONE, m_fps);
	m_dwMspf = (u32)XF_XF32_TO_S32(m_spf*1000);
}

}	// end of namespace fnd
}	// end of namespace iris
