//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndTimer.cpp
 * @brief		TimerC^[tFCXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndTimer_CPP_

//======================================================================
// include
#include "FndTimer.h"
#include "FndFps.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
ITimer::ITimer(void)
: m_LastTime(0)
, m_BaseTime(0)
, m_StopTime(0)
, m_fTosec(1.0f/1000.0f)
{
}

/**********************************************************************//**
 *
 * EZbg
 *
*//***********************************************************************/
void ITimer::Reset(void)
{
	Activate(true);
	u64 time = GetNowTime();
	m_LastTime = time;
	m_BaseTime = time;
	m_StopTime = 0;
}

/**********************************************************************//**
 *
 * v̊Jn
 *
*//***********************************************************************/
void ITimer::Resume(void)
{
	if(!IsActive())
	{
		Activate(true);
		u64 time = GetNowTime();
		m_BaseTime += time - m_StopTime;
		m_LastTime = time;
		m_StopTime = 0;
	}
}

/**********************************************************************//**
 *
 * v̒~
 *
*//***********************************************************************/
void ITimer::Suspend(void)
{
	if(IsActive())
	{
		u64 time = GetNowTime();
		m_LastTime = time;
		m_StopTime = time;
		Activate(false);
	}
}

/**********************************************************************//**
 *
 * Sync
 *
 ----------------------------------------------------------------------
 * @return	syncꍇ́Atrue
*//***********************************************************************/
//bool ITimer::Sync(bool sleep)
//{
//	while(1)
//	{
//		u64 mspf = fnd::MSPF();
//		u64 time = GetElapsedMilliSecondRef();
//		if( time > mspf )
//		{
//			m_LastTime += mspf;
//			return true;
//		}
//		if( !sleep ) break;
//
//		Sleep((DWORD)(mspf-time));
//	}
//	return false;
//}

/**********************************************************************//**
 *
 * oߎԂ̎擾iSyncj
 *
 -----------------------------------------------------------------------
 * @return oߎ
*//***********************************************************************/
//float ITimer::GetSyncElapsedSecond(void)
//{
//	return fnd::SPF();
//}

/**********************************************************************//**
 *
 * oߕb̎擾
 *
 -----------------------------------------------------------------------
 * @return oߕb
*//***********************************************************************/
f32 ITimer::GetElapsedSecond(void)	const
{
	return GetElapsedMilliSecond() * m_fTosec;
}

/**********************************************************************//**
 *
 * ^C}[ZbgƂ̌oߕb
 *
 -----------------------------------------------------------------------
 * @return oߕb
*//***********************************************************************/
f32 ITimer::GetStockSecond(void)	const
{
	return GetStockMilliSecond() * m_fTosec;
}

/**********************************************************************//**
 *
 * oߕb̎擾iQƁj
 *
 -----------------------------------------------------------------------
 * @return oߕb
*//***********************************************************************/
f32 ITimer::GetElapsedSecondRef(void)	const
{
	return GetElapsedMilliSecondRef() * m_fTosec;
}

}	// end of namespace fnd
}	// end of namespace iris
