//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndEndian.cpp
 * @brief		GfBAΉt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndEndian_CPP_

//======================================================================
// include
#include "FndEndian.h"

namespace iris {
namespace fnd
{

//======================================================================
// function
/**********************************************************************//**
 *
 * GfBA̔]
 *
 * @note	pDst == pSrc OK.
 *
 ----------------------------------------------------------------------
 * @param [out]	pDst	= o
 * @param [in]	pSrc	= 
 * @param [in]	size	= TCY
 * @param [in]	tsize	= ^TCY
 * @return	
*//***********************************************************************/
BOOL ReversEndian(void* pDst, const void* pSrc, u32 size, u32 tsize)
{
	if( tsize == 0 ) return 0;
	u8* d = (u8*)pDst;
	u8* s = (u8*)pSrc;

	if( tsize & 1 )
	{
		for( u32 i=0; i < size; ++i, ++d, ++s )
			*d = *s;
		//memmove( pDst, pSrc, size );
		return 1;
	}
	u8 tmp=0;
	for( u32 i=0, n=size/tsize; i < n; ++i )
	{
		for( u32 j=0, m=tsize/2; j < m; ++j )
		{
			tmp = *(s+tsize-1-j);
			*(d+tsize-1-j)	= *(s+j);
			*(d+j)			= tmp;
		}
		s += tsize;
		d += tsize;
	}
	return 1;
}

}	// end of namespace fnd
}	// end of namespace iris
