//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndLargeVariable.h
 * @brief		{ϐNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndLargeVariable_H_
#define INCG_IRIS_FndLargeVariable_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"
#include "../../ml/iml_type_info.hpp"
#include <string.h>

namespace iris {
namespace fnd
{

//======================================================================
// declare
template<u32 nBITS, bool bBE>class CLargeVariable;

//======================================================================
// class

//======================================================================
/**
 * @brief		Œ蒷{ϐNX
 * @note		TODO : ɂ2̕␔gpBi܂As肻j
 *				̂낢ȂBBB
 *
 * @tparam	nBITS	= rbg
 * @tparam	bBE		= rbOGfBAǂ
 */
template<u32 nBITS
#ifdef __BIG_ENDIAN__
	, bool bBE=true
#else
	, bool bBE=false
#endif
>
class CLargeVariable : public IIrisObject
{
	typedef CLargeVariable<nBITS, bBE>	_Myt;
public:
	typedef u32			value_type;
	typedef u32			*value_ptr;
	typedef u64			large_type;
	enum
	{
		VSIZE	= iml::type_info<value_type>::bits,
		LSIZE	= iml::type_info<large_type>::bits,

		BITS	= nBITS,
		BYTES	= (BITS+7)/8,
		LSB		= 0,
	};
	static const u32 ARRAYS		= (BITS+31)/VSIZE;
	static const u32 MSB		= ARRAYS-1;
	static const u32 SIGNBIT	= ARRAYS*VSIZE-1;
	static const value_type	VMSB	= 0x80000000;
	static const value_type	VMASK	= 0xFFFFFFFF;

private:
	template<bool be>
	class data_type
	{
	private:
		struct reverse_data
		{
			value_type	data[ARRAYS];
			value_type&			operator [] (s32 idx)		{ return data[ARRAYS-idx-1]; }
			const value_type&	operator [] (s32 idx) const	{ return data[ARRAYS-idx-1]; }
			operator	void*		(void)			{ return pointer_cast<void*>(data); }
			operator	const void*	(void)	const	{ return pointer_cast<const void*>(data); }
		};
		template<bool b, typename DMY>
		struct type_impl
		{
			reverse_data	data;
		};
		template<typename DMY>
		struct type_impl<true, DMY>
		{
			value_type		data[ARRAYS];
		};
	public:
		typedef typename type_impl<be, void>	type;
	};
	// l
	typename data_type<bBE>::type	m_variable;

public:
	// RXgN^
	CLargeVariable(void)					{ Zero(); }
	CLargeVariable(const _Myt& src)			{ memcpy(m_variable.data, src.m_variable.data , sizeof(m_variable.data) ); }
	CLargeVariable(const _Myt* src)			{ memcpy(m_variable.data, src->m_variable.data, sizeof(m_variable.data) ); }
	CLargeVariable(u64 number)				{ Copy(number); }
	CLargeVariable(s64 number)				{ Copy(number); }
	CLargeVariable(u32 number)				{ Copy((u64)number); }
	CLargeVariable(s32 number)				{ Copy((s64)number); }
	CLargeVariable(u16 number)				{ Copy((u64)number); }
	CLargeVariable(s16 number)				{ Copy((s64)number); }
	CLargeVariable(u8  number)				{ Copy((u64)number); }
	CLargeVariable(s8  number)				{ Copy((s64)number); }
	CLargeVariable(unsigned int number)		{ Copy((u64)number); }
	CLargeVariable(int number)				{ Copy((s64)number); }

	template<u32 OTHER, bool E>
	CLargeVariable(const CLargeVariable<OTHER, E>& src)	{ Copy(src); }
	template<u32 OTHER, bool E>
	CLargeVariable(const CLargeVariable<OTHER, E>* src)	{ Copy(*src); }

	CLargeVariable(s32 datas, bool sign, ...);
	CLargeVariable(s32 datas, value_type pArray[]);
	CLargeVariable(const char* str)	{ StringTo(str); }

	// fXgN^
	~CLargeVariable(void) {}

public:
	// LXg operator
	operator	u32	(void)	const		{ return UnsignedCast<u32>(); }
	operator	u16	(void)	const		{ return UnsignedCast<u16>(); }
	operator	u8 	(void)	const		{ return UnsignedCast<u8>(); }
	operator	u64	(void)	const		{ return UnsignedCast<u64>(); }
	operator	s32	(void)	const		{ return SignedCast<s32>(); }
	operator	s16	(void)	const		{ return SignedCast<s16>(); }
	operator	s8 	(void)	const		{ return SignedCast<s8>(); }
	operator	s64	(void)	const		{ return SignedCast<s64>(); }

	operator	char(void)	const		{ return SignedCast<char>(); }
	operator	int	(void)	const		{ return SignedCast<int>(); }
	operator	unsigned int (void) const	{ return UnsignedCast<unsigned int>(); }

public:
	// lZ operator
	_Myt&		operator =		(const _Myt& v)			{ return Copy(v); }
	const _Myt	operator +		(void)					{ return *this; }
	const _Myt	operator +		(const _Myt& v) const	{ _Myt t(this); t += v; return t; }
	const _Myt	operator -		(void)			const	{ _Myt t;		t -= *this; return t; }
	const _Myt	operator -		(const _Myt& v)	const	{ _Myt t(this); t -= v; return t; }
	const _Myt	operator *		(const _Myt& v)	const	{ _Myt t(this); t *= v; return t; }
	const _Myt	operator /		(const _Myt& v)	const	{ _Myt t(this); t /= v; return t; }
	const _Myt	operator %		(const _Myt& v)	const	{ _Myt t(this); t %= v; return t; }
	_Myt&		operator +=		(const _Myt& v)			{ return Add(v); }
	_Myt&		operator -=		(const _Myt& v)			{ return Sub(v); }
	_Myt&		operator *=		(const _Myt& v)			{ return Mul(v); }
	_Myt&		operator /=		(const _Myt& v)			{ return Div(v); }
	_Myt&		operator %=		(const _Myt& v)			{ return Mod(v); }

	_Myt	operator ++		(void)					{ return Add(1); }
	_Myt	operator ++		(int)					{ _Myt t(this); Add(1); return t; }
	_Myt	operator --		(void)					{ return Sub(1); }
	_Myt	operator --		(int)					{ _Myt t(this); Sub(1); return t; }

	template<typename _TN>
	_Myt	operator <<		(_TN shift)	const		{ _Myt t(this); t <<= shift; return t; }
	template<typename _TN>
	_Myt	operator >>		(_TN shift)	const		{ _Myt t(this); t >>= shift; return t; }
	template<typename _TN>
	_Myt&	operator <<=	(_TN shift)				{ return LShift((u32)shift); }
	template<typename _TN>
	_Myt&	operator >>=	(_TN shift)				{ return RShift((u32)shift); }

	const _Myt	operator |		(const _Myt& v)	const	{ _Myt t(this); t |= v; return t; }
	const _Myt	operator &		(const _Myt& v)	const	{ _Myt t(this); t &= v; return t; }
	const _Myt	operator ^		(const _Myt& v)	const	{ _Myt t(this); t ^= v; return t; }
	_Myt&		operator |=		(const _Myt& v)			{ return OR(v); }
	_Myt&		operator &=		(const _Myt& v)			{ return AND(v); }
	_Myt&		operator ^=		(const _Myt& v)			{ return XOR(v); }
	_Myt&		operator ~		(void)					{ return NOT(); }

	bool	operator >		(const _Myt& v)	const	{ return IsGreater(v); }
	bool	operator >=		(const _Myt& v)	const	{ return !IsLess(v); }
	bool	operator <		(const _Myt& v)	const	{ return IsLess(v); }
	bool	operator <=		(const _Myt& v)	const	{ return !IsGreater(v); }
	bool	operator ==		(const _Myt& v)	const	{ return IsEqual(v); }
	bool	operator !=		(const _Myt& v)	const	{ return !IsEqual(v); }

	template<typename _TN>
	value_type		operator []		(_TN index)				{ return GetValue((u32)index); }
	template<typename _TN>
	value_type		operator []		(_TN index)		const	{ return GetValue((u32)index); }

public:
	// lZ operator (template)
	template<typename _TN>
	_Myt&		operator =		(_TN v)	const	{ return Copy(v); }
	template<typename _TN>
	const _Myt	operator +		(_TN v)	const	{ _Myt t(this); t += v; return t; }
	template<typename _TN>
	const _Myt	operator -		(_TN v)	const	{ _Myt t(this); t -= v; return t; }
	template<typename _TN>
	const _Myt	operator *		(_TN v)	const	{ _Myt t(this); t *= v; return t; }
	template<typename _TN>
	const _Myt	operator /		(_TN v)	const	{ _Myt t(this); t /= v; return t; }
	template<typename _TN>
	const _Myt	operator %		(_TN v)	const	{ _Myt t(this); t %= v; return t; }
	template<typename _TN>
	_Myt&		operator +=		(_TN v)			{ return Add(v); }
	template<typename _TN>
	_Myt&		operator -=		(_TN v)			{ return Sub(v); }
	template<typename _TN>
	_Myt&		operator *=		(_TN v)			{ return Mul(v); }
	template<typename _TN>
	_Myt&		operator /=		(_TN v)			{ return Div(v); }
	template<typename _TN>
	_Myt&		operator %=		(_TN v)			{ return Mod(v); }

	template<typename _TN>
	_Myt	operator |		(_TN v)	const	{ _Myt t(this); t |= v; return t; }
	template<typename _TN>
	_Myt	operator &		(_TN v)	const	{ _Myt t(this); t &= v; return t; }
	template<typename _TN>
	_Myt	operator ^		(_TN v)	const	{ _Myt t(this); t ^= v; return t; }
	template<typename _TN>
	_Myt&	operator |=		(_TN v)			{ return OR(v); }
	template<typename _TN>
	_Myt&	operator &=		(_TN v)			{ return AND(v); }
	template<typename _TN>
	_Myt&	operator ^=		(_TN v)			{ return XOR(v); }

	template<typename _TN>
	bool	operator >		(_TN v)	const	{ return IsGreater(v); }
	template<typename _TN>
	bool	operator >=		(_TN v)	const	{ return !IsLess(v); }
	template<typename _TN>
	bool	operator <		(_TN v)	const	{ return IsLess(v); }
	template<typename _TN>
	bool	operator <=		(_TN v)	const	{ return !IsGreater(v); }
	template<typename _TN>
	bool	operator ==		(_TN v)	const	{ return IsEqual(v); }
	template<typename _TN>
	bool	operator !=		(_TN v)	const	{ return !IsEqual(v); }

public:
	/// zero fill
	void	Zero(void)
	{
		memset(m_variable.data, 0, sizeof(m_variable.data) );
	}
	/// ==
	bool	IsEqual(const _Myt& v) const
	{
		for( int i=0; i < ARRAYS; ++i ) if( m_variable.data[i] != v.m_variable.data[i] ) return false;
		return true;
	}
	/// <
	bool	IsLess(const _Myt& v) const
	{
		if( IsSign() != v.IsSign() ) return IsSign();
		for( int i=MSB; i >= 0; --i )
		{
			if( m_variable.data[i] > v.m_variable.data[i] ) return false;
			if( m_variable.data[i] < v.m_variable.data[i] ) return true;
		}
		return false;
	}
	/// >
	bool	IsGreater(const _Myt& v) const
	{
		if( IsSign() != v.IsSign() ) return v.IsSign();
		for( int i=MSB; i >= 0; --i )
		{
			if( m_variable.data[i] > v.m_variable.data[i] ) return true;
			if( m_variable.data[i] < v.m_variable.data[i] ) return false;
		}
		return false;
	}
	/// =
	_Myt&	Copy(const _Myt& v)
	{
		memcpy(m_variable.data, v.m_variable.data, sizeof(m_variable.data) );
		return *this;
	}
	/// =
	template<u32 OTHER, bool E>
	_Myt&	Copy(const CLargeVariable<OTHER, E>& v)
	{
		u32 i=0;
		value_type tmp = 0;
		if( v.IsSign() ) tmp = VMASK;

		for( ; i < CLargeVariable<OTHER, E>::ARRAYS && i < ARRAYS; ++i )
		{
			m_variable.data[i] = v.GetValue(i);
		}
		for( ; i < ARRAYS; ++i ) m_variable.data[i] = tmp;
		return *this;
	}
	/// = (u64)
	_Myt&	Copy(u64 v)
	{
		int i=0;
		value_type tmp = 0;
		value_ptr pv = m_variable.data;
		if( (v>>63) & 1 ) tmp = VMASK;

		for( int n=sizeof(s64)/sizeof(value_type); i < n; ++i, ++pv )
		{
			*pv = (value_type)(v&VMASK);
			v >>= VSIZE;
		}
		for( ; i < ARRAYS; ++i, ++pv ) *pv = tmp;
		return *this;
	}
	/// = (s64)
	_Myt&	Copy(s64 v)
	{
		int i=0;
		value_type tmp = 0;
		if( v < 0 ) tmp = VMASK;

		for( int n=sizeof(s64)/sizeof(value_type); i < n; ++i )
		{
			m_variable.data[i] = (value_type)(v&VMASK);
			v >>= VSIZE;
		}
		for( ; i < ARRAYS; ++i ) m_variable.data[i] = tmp;
		return *this;
	}
	/// cast (unsigend)
	template<typename _TN>
	_TN		UnsignedCast(void) const
	{
		_TN ret = (_TN)m_variable.data[0];
		for( int i=1, n=sizeof(_TN)/sizeof(value_type); i < n; ++i )
		{
			ret |= m_variable.data[i] << (i*VSIZE);
		}
		return ret;
	}
	/// cast (sigend)
	template<typename _TN>
	_TN		SignedCast(void) const
	{
		_TN ret = (_TN)m_variable.data[0];
		s32 tnsz = sizeof(_TN);
		for( int i=1, n=tnsz/(s32)sizeof(value_type); i < n; ++i )
		{
			ret |= m_variable.data[i] << (i*VSIZE);
		}
		ret &= ~((_TN)1<<(tnsz*8-1));
		if( IsSign() ) ret |= ((_TN)1<<(tnsz*8-1));
		return ret;
	}
	/// |
	_Myt&	OR(const _Myt& v)
	{
		for( int i=0; i < ARRAYS; ++i ) m_variable.data[i] |= v.m_variable.data[i];
		return *this;
	}
	/// &
	_Myt&	AND(const _Myt& v)
	{
		for( int i=0; i < ARRAYS; ++i ) m_variable.data[i] &= v.m_variable.data[i];
		return *this;
	}
	/// ^
	_Myt&	XOR(const _Myt& v)
	{
		for( int i=0; i < ARRAYS; ++i ) m_variable.data[i] ^= v.m_variable.data[i];
		return *this;
	}
	/// ~
	_Myt&	NOT(void)
	{
		for( int i=ARRAYS; i > 0; --i ) m_variable.data[i] = ~m_variable.data[i];
		return *this;
	}
	/// <<
	_Myt&	LShift(u32 shift)
	{
		// VSIZEbitȏ̃VtgɑΉ
		if( shift > VSIZE )
		{
			u32 byte = shift/VSIZE;
			shift -= byte*VSIZE;
			if( byte > ARRAYS )
			{
				byte = ARRAYS;
				shift = 0;
			}
			for( u32 i=MSB, j=ARRAYS-byte; j > 0; --i, --j )
				m_variable.data[i] = m_variable.data[j-1];
			for( u32 i=0; i < byte; ++i )
				m_variable.data[i] = 0;
		}
		if( shift != 0 )
		{
			large_type low=0;
			for( int i=0; i < ARRAYS; ++i )
			{
				large_type a = (((large_type)m_variable.data[i]) << shift) | low;
				m_variable.data[i] = (value_type)(a & VMASK);
				low = ((a >> VSIZE) & VMASK);
			}
		}
		return *this;
	}
	/// >>
	_Myt&	RShift(u32 shift)
	{
		// 32bitȏ̃VtgɑΉ
		if( shift > VSIZE )
		{
			u32 byte = shift/VSIZE;
			shift -= byte*VSIZE;
			if( byte > ARRAYS )
			{
				byte = ARRAYS;
				shift = 0;
			}
			u32 i=0;
			for( u32 j=byte; i < ARRAYS-byte; ++i, ++j )
				m_variable.data[i] = m_variable.data[j];
			for( ; i < ARRAYS; ++i )
				m_variable.data[i] = 0;
		}
		if( shift != 0 )
		{
			large_type hi=0;
			shift = VSIZE - shift;
			for( int i=MSB; i >= 0; --i )
			{
				large_type a = (((large_type)m_variable.data[i]) << shift) | (hi<<VSIZE);
				m_variable.data[i] = (value_type)((a >> VSIZE) & VMASK);
				hi = (a & VMASK);
			}
		}
		return *this;
	}
	/// bit擾
	bool	Bit(u32 offset)	const
	{
		if(offset > SIGNBIT) return false;
		u32 index = offset/VSIZE;
		offset -= index*VSIZE;
		return ( m_variable.data[index] & (1<<offset) ) ? true : false;
	}
	/// sign
	bool	IsSign(void) const
	{
		return ( m_variable.data[MSB] & VMSB ) ? true : false;
		//return Bit(SIGNBIT);
	}
public:
	// lZ function
	/// +
	_Myt&	Add(const _Myt& v)
	{
#ifdef _IRIS_DEBUG
		bool sign = IsSign();
#endif
		large_type   up = 0;
		for( int i=0; i < ARRAYS; ++i )
		{
			large_type a = (large_type)(m_variable.data[i]) + (large_type)(v.m_variable.data[i]) + up;
			m_variable.data[i] = (value_type)(a & VMASK);
			up = ((a >> 32) & VMASK);
		}
#ifdef _IRIS_DEBUG
		IRIS_ASSERT( sign || v.IsSign() || up == 0 );
#endif
		return *this;
	}
	/// |
	_Myt&	Sub(const _Myt& v)
	{
		large_type   up = 1;
		for( int i=0; i < ARRAYS; ++i )
		{
			large_type a = (large_type)(m_variable.data[i]) + ( ~(large_type)(v.m_variable.data[i]) & ((value_type)-1)) + up;
			m_variable.data[i] = (value_type)(a & VMASK);
			up = ((a >> VSIZE) & VMASK);
		}
		return *this;
	}
	/// *
	_Myt&	Mul(const _Myt& v)
	{
		// TODO:tvH
		_Myt a(this);
		_Myt ret;
		for(int i=0; i < ARRAYS; ++i )
		{
			for( int j=0; j < VSIZE; ++j )
			{
				if( v.m_variable.data[i] & (1<<j) ) ret += a;
				a <<= 1;
			}
		}
		Copy(ret);
		return *this;
	}
	/// /
	_Myt&	Div(const _Myt& v)
	{
		// TODO:tvH
		_Myt a(this);
		Zero();
		int i, j=VSIZE-2;
		for( i=MSB; i >= 0; --i )
		{
			for( ; j >= 0; --j )
			{
				if( (a >> (i*VSIZE+j)) >= v )
				{
					m_variable.data[i] |= (1 << j);
					a -= (v << (i*VSIZE+j));
				}
			}
			j = VSIZE - 1;
		}
		return *this;
	}
	/// %
	_Myt&	Mod(const _Myt& v)
	{
		int i, j=VSIZE-2;
		for( i=MSB; i >= 0; --i )
		{
			for( ; j >= 0; --j )
			{
				if( (*this >> (i*VSIZE+j)) >= v )
				{
					*this -= (v << (i*VSIZE+j));
				}
			}
			j = VSIZE - 1;
		}
		return *this;
	}

public:
	/// string ->
	void	StringTo(const char* str)
	{
		Zero();
		if( str == nullptr ) return;
		if( str[0] == '\0' ) return;
		const char* msb = str;
		int tmp=0, base = 10, sign = 0;
		_Myt digit = 1;
		if( msb[0] == '-' ) { ++msb; sign = 1; }
		if( msb[0] == '0' && msb[1] == 'x' ) { base = 16; msb += 2; }
		const char* p = msb;
		while( *(p+1) != '\0' ) { ++p; }
		while(1)
		{
			if( base == 16 )
			{
				if( *p >= 'a' && *p <= 'f' )
				{
					tmp = *p - 'a' + 10;
					Add(digit*tmp);
				}
				if( *p >= 'A' && *p <= 'F' )
				{
					tmp = *p - 'A' + 10;
					Add(digit*tmp);
				}
			}
			if( *p >= '0' && *p <= '9' )
			{
				tmp = *p - '0';
				Add(digit*tmp);
			}
			digit *= base;
			if( p == msb ) break;
			--p;
		}
		m_variable.data[MSB] |= (sign << (VSIZE-1));
	}

	// to string
	s32		ToString(char* str, s32 size)
	{
		// 10i
		_Myt tmp(this);
		int i=0;
		if( str == nullptr )
		{
			for( ; tmp != 0; ++i, tmp/=10) {}
			return i;
		}
		for( ; i < size && tmp != 0; ++i, tmp/=10)
		{
			str[i] = tmp%10 + '0';
		}
		str[i] = '\0';
		_strrev(str);
		return i;
	}
public:
	// get
	/// z̒g擾
	value_type		GetValue(u32 index)			{ return (index >= ARRAYS) ? 0 : m_variable.data[index]; }
	/// z̒g擾
	value_type		GetValue(u32 index) const	{ return (index >= ARRAYS) ? 0 : m_variable.data[index]; }
};

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	datas	=  ... ̐
 * @param [in]	sign	= dummy
 * @param [in]	...		= m_variable.data[1] = arg1, m_variable.data[0] = arg2
*//***********************************************************************/
template<u32 nBITS, bool bBE>
CLargeVariable<nBITS, bBE>::CLargeVariable(s32 datas, bool sign, ...)
{
	memset(m_variable.data, 0, sizeof(m_variable.data) );
	if( datas > ARRAYS ) datas = ARRAYS;
	va_list va;
	va_start(va, sign);
	for( int i=(datas-1); i >= 0; --i )
	{
		m_variable.data[i] = va_arg(va, value_type);
	}
	va_end(va);
	//m_variable.data[MSB] &= ~(1<<(VSIZE-1));
	//if( sign ) m_variable.data[MSB] |= (1<<(VSIZE-1));
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	datas	= pArray̔z
 * @param [in]	pArray	= memcpy
*//***********************************************************************/
template<u32 nBITS, bool bBE>
CLargeVariable<nBITS, bBE>::CLargeVariable(s32 datas, value_type pArray[])
{
	if( datas > ARRAYS ) datas = ARRAYS;
	memcpy( m_variable.data, pArray, datas*sizeof(value_type) );
	value_type tmp = 0;
	if( datas < ARRAYS )
	{
		if( pArray[datas-1] & VMSB ) tmp = VMASK;
		for( int i=datas; i < ARRAYS; ++i ) m_variable.data[i] = tmp;
	}
}

}	// end of namespace fnd
}	// end of namespace iris

// iostream
#ifndef _IRIS_NOT_SUPPORT_IOSTREAM

#if defined(__cplusplus)
#include <iostream>

template<iris::u32 nBITS, bool bBE>
std::ostream& operator << (std::ostream& o, const iris::fnd::CLargeVariable<nBITS, bBE>& v)
{
	int i;
	for( i=iris::fnd::CLargeVariable<nBITS>::MSB; i > 0; --i )
	{
		if( v[i] != 0 ) break;
	}
	o << "0x";
	for( ; i > 0; --i )
	{
		o << std::hex << v[i] << "," << std::dec;
	}
	o << std::hex << v[i] << std::dec;
	return o;
}

#endif
#endif	// #ifndef _IRIS_NOT_SUPPORT_IOSTREAM


#endif
