//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndArgAnalyzer.cpp
 * @brief		arg̓NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndArgAnalyzer_CPP_

//======================================================================
// include
#include "FndArgAnalyzer.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	argc	= argv̔zvf
 * @param [in]	argv	= z
*//***********************************************************************/
CArgAnalyzer::CArgAnalyzer(int argc, char* argv[])
: m_argc(argc)
, m_argv(argv)
{
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CArgAnalyzer::Analyze(void)
{
	CCollecter* p = m_Observer.GetObservers();
	while( p != nullptr )
	{
		p->m_pArg = nullptr;
		for( int i=0; i < m_argc; ++i )
		{
			if( strcmp(m_argv[i], p->m_Name) == 0 )
			{
				p->m_pArg = m_argv[i];
				break;
			}
		}
		p = p->GetNext();
	}
}

/**********************************************************************//**
 *
 * s
 *
 -----------------------------------------------------------------------
 * @param [in]	pUser	= [U[gp
*//***********************************************************************/
void CArgAnalyzer::Exec(void* pUser)
{
	CCollecter* p = m_Observer.GetObservers();
	while( p != nullptr )
	{
		if( p->IsFind() ) p->Exec(pUser);
		p = p->GetNext();
	}
}

}	// end of namespace fnd
}	// end of namespace iris
