//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFade.cpp
 * @brief		tF[hNXC^[tFCX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndFade_CPP_

//======================================================================
// include
#include "FndFade.h"

namespace iris {
namespace fnd
{

//======================================================================
// class

//======================================================================
// class
// IFade
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
IFade::IFade(void)
: CFlag(eFADE_NONE)
, m_fA(XF32_ZERO)
, m_fR(XF32_ZERO)
, m_fG(XF32_ZERO)
, m_fB(XF32_ZERO)
, m_fAlpha(XF32_ZERO)
, m_fVariable(XF32_ZERO)
{
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void IFade::Update(xf32 time)
{
	switch(m_Flag)
	{
	case eFADE_NONE:
	default:
		break;
	case eFADE_IN:
		{
			xf32 a = m_fA;
			m_fA -= XF32_Mul(m_fVariable, time);
			if( (m_fA <= m_fAlpha && m_fAlpha < a)
				|| (a < m_fAlpha && m_fAlpha <= m_fA) )
			{
				m_fA = m_fAlpha;
				CopyFlag(eFADE_NONE);
			}
			ChangeFadeColor();
		}
		break;
	case eFADE_OUT:
		{
			xf32 a = m_fA;
			m_fA += XF32_Mul(m_fVariable, time);
			if( (a < m_fAlpha && m_fAlpha <= m_fA)
				|| (m_fA <= m_fAlpha && m_fAlpha < a) )
			{
				m_fA = m_fAlpha;
				CopyFlag(eFADE_NONE);
			}
			ChangeFadeColor();
		}
		break;
	}
}

/**********************************************************************//**
 *
 * tF[hC
 *
 ----------------------------------------------------------------------
 * @param [in]	alpha		= ڕWAt@l
 * @param [in]	time		= tF[h
*//***********************************************************************/
void IFade::FadeInT(xf32 alpha, xf32 time)
{
	if( time <= XF32_ZERO ) return;
	// ݂̃At@lϓlZo
	xf32 a = m_fA - alpha;
	m_fVariable = XF32_Div(a, time);
	CopyFlag(eFADE_IN);
}

/**********************************************************************//**
 *
 * tF[hC
 *
 ----------------------------------------------------------------------
 * @param [in]	alpha		= ڕWAt@l
 * @param [in]	variable	= ϓl
*//***********************************************************************/
void IFade::FadeInV(xf32 alpha, xf32 variable)
{
	// ݂̃At@lϓlZo
	xf32 a = m_fA - alpha;
	if( XF32_Mul(a, variable) < XF32_ZERO ) variable = -variable;
	m_fVariable = variable;
	CopyFlag(eFADE_IN);
}

/**********************************************************************//**
 *
 * tF[hAEg
 *
 ----------------------------------------------------------------------
 * @param [in]	alpha		= ڕWAt@l
 * @param [in]	time		= tF[h
*//***********************************************************************/
void IFade::FadeOutT(xf32 alpha, xf32 time)
{
	if( time <= XF32_ZERO ) return;
	// ݂̃At@lϓlZo
	xf32 a = alpha - m_fA;
	m_fVariable = XF32_Div(a, time);
	CopyFlag(eFADE_OUT);
}

/**********************************************************************//**
 *
 * tF[hAEg
 *
 ----------------------------------------------------------------------
 * @param [in]	alpha		= ڕWAt@l
 * @param [in]	variable	= ϓl
*//***********************************************************************/
void IFade::FadeOutV(xf32 alpha, xf32 variable)
{
	// ݂̃At@lϓlZo
	xf32 a = alpha - m_fA;
	if( XF32_Mul(a, variable) < XF32_ZERO ) variable = -variable;
	m_fVariable = variable;
	CopyFlag(eFADE_OUT);
}

/**********************************************************************//**
 *
 * tF[hJ[ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	color	= tF[hJ[
*//***********************************************************************/
void IFade::SetFadeColor(u32 color)
{
	m_fR = XF32_Div(XF_S32_TO_XF32((color>>16)&0xFF), XF32_255);
	m_fG = XF32_Div(XF_S32_TO_XF32((color>> 8)&0xFF), XF32_255);
	m_fB = XF32_Div(XF_S32_TO_XF32((color>> 0)&0xFF), XF32_255);
}

/**********************************************************************//**
 *
 * tF[hJ[擾
 *
 ----------------------------------------------------------------------
 * @return [in]	tF[hJ[
*//***********************************************************************/
u32 IFade::GetFadeColor(void)
{
	u32 r, g, b, a;
	r = XF_XF32_TO_U32(m_fR * 0xFF);
	g = XF_XF32_TO_U32(m_fG * 0xFF);
	b = XF_XF32_TO_U32(m_fB * 0xFF);
	a = XF_XF32_TO_U32(m_fA * 0xFF);
	return (a<<24)|(r<<16)|(g<<8)|b;
}

}	// end of namespace fnd
}	// end of namespace iris
