//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFlag.h
 * @brief		tONXx[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndFlag_H_
#define INCG_IRIS_FndFlag_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class CFlag;
class CProtectedFlag;

// NX}N
#define IRIS_PP_DECLARE_FLAG_CLASS(name)		IRIS_PP_DECLARE_FLAG_CLASSEX(name, name, s32, public, public, public, public)

#define IRIS_PP_DECLARE_FLAG_CLASSEX(name, classname, type_, ac_get, ac_bit, ac_set, ac_ope)	\
class C##classname {								\
	typedef C##classname	MyClass;				\
protected:											\
	type_		m_##name;							\
public:												\
	C##classname(void) : m_##name(0) {}				\
	C##classname(type_ flag) : m_##name(flag) {}	\
	~C##classname(void) {}							\
ac_get:												\
	type_	Get##name(void)				const	{ return m_##name; }					\
	bool	Is##name(type_ bit)			const	{ return ((m_##name & bit) != 0); }		\
	bool	IsEqual##name(type_ bit)	const	{ return ((m_##name & bit) == bit); }	\
ac_bit:																					\
	void	Enable##name(type_ bit)		{ m_##name |= bit; }							\
	void	Disable##name(type_ bit)	{ m_##name &= ~bit; }							\
	void	Set##name(type_ bit, bool enable)	{ enable ? Enable##name(bit) : Disable##name(bit); }		\
	void	Enable##name##Mask(type_ mask, type_ value)	{ Disable##name(mask); Enable##name(mask&value); }	\
ac_set:																		\
	void	Set##name(type_ flag)	{ m_##name = flag; }					\
	void	Copy##name(type_ flag)	{ m_##name = flag; }					\
	void	Clear##name(void)		{ m_##name = 0; }						\
ac_ope:																		\
	MyClass&	operator | (const MyClass& rhs)	{ m_##name |= rhs.m_##name; return *this; }	\
	MyClass&	operator & (const MyClass& rhs)	{ m_##name &= rhs.m_##name; return *this; }	\
	MyClass&	operator ^ (const MyClass& rhs)	{ m_##name ^= rhs.m_##name; return *this; }	\
}

//======================================================================
// tONX
//! public flag class "CFlag"
IRIS_PP_DECLARE_FLAG_CLASS(Flag);

//! protected flag class "CProtectedFlag"
IRIS_PP_DECLARE_FLAG_CLASSEX(Flag, ProtectedFlag, s32, public, protected, protected, protected);

}	// end of namespace fnd
}	// end of namespace iris

#endif
