//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndLabeling.h
 * @brief		xO⏕ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndLabeling_H_
#define INCG_IRIS_FndLabeling_H_

//======================================================================
// include
#include "../container/FndList.h"
#include "../container/FndObserver.h"
#include "../container/FndAllocator.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
template<typename _TN>class CLabelBlock;
template<typename _TN>class CLabelLine;
template<typename _TN>class CLabelGroup;

//======================================================================
// define
#define DYNAMIC_ALLOCATE	1

//======================================================================
// class
/// xqɃNX
template<typename _TN, typename _Allocator>
class CLabelStore : public INonCopyable<>
{
	typedef _TN								value_type;
	typedef CLabelStore<_TN, _Allocator>	_Myt;
public:
	typedef CLabelGroup<_TN>		Group;
	typedef typename Group::Line	Line;
	typedef typename Line::Block	Block;

	typedef CList<Group>				GroupList;
	typedef typename Group::LineList	LineList;
	typedef typename Line::BlockList	BlockList;

	typedef CAllocatorInstance<typename _Allocator::template rebind<Group>::type>	GAllocator;
	typedef CAllocatorInstance<typename _Allocator::template rebind<Line>::type>	LAllocator;
	typedef CAllocatorInstance<typename _Allocator::template rebind<Block>::type>	BAllocator;
public:
	template<typename _TN, typename _LIST>
	class Subject : public CSubject<_TN>
	{
	public:
		_LIST			m_List;	//!< 󂫃Xg
	public:
		/// Observer̍폜
		virtual void	DetachObserver(typename CSubject<_TN>::Observer* observer)
		{
			CSubject<_TN>::DetachObserver(observer);
			m_List.push_back(static_cast<_TN*>(observer));
		}
	};
	typedef Subject<Group, GroupList>	GroupSubject;
	typedef Subject<Line , LineList >	LineSubject;
	typedef Subject<Block, BlockList>	BlockSubject;
protected:
	GroupSubject	m_GSubject;	//!< O[vXg
	LineSubject		m_LSubject;	//!< CXg
	BlockSubject	m_BSubject;	//!< ubNXg

public:
	/// RXgN^
	CLabelStore(s32 group, s32 line, s32 block)
	{
		for( int i=0; i < group; ++i )	m_GSubject.m_List.push_back( reinterpret_cast<Group*>(GAllocator::allocator().alloc(1)) );
		for( int i=0; i < line; ++i )	m_LSubject.m_List.push_back( reinterpret_cast<Line* >(LAllocator::allocator().alloc(1)) );
		for( int i=0; i < block; ++i )	m_BSubject.m_List.push_back( reinterpret_cast<Block*>(BAllocator::allocator().alloc(1)) );
	}
	/// fXgN^
	~CLabelStore(void)
	{
		m_GSubject.DetachObserverAll();
		m_LSubject.DetachObserverAll();
		m_BSubject.DetachObserverAll();
		for( typename GroupList::iterator it=m_GSubject.m_List.begin(), end=m_GSubject.m_List.end(); it != end; )
		{
			Group* p = &it;
			it = m_GSubject.m_List.erase(it);
			GAllocator::allocator().dealloc(p);
		}
		for( typename LineList::iterator it=m_LSubject.m_List.begin(), end=m_LSubject.m_List.end(); it != end; )
		{
			Line* p = &it;
			it = m_LSubject.m_List.erase(it);
			LAllocator::allocator().dealloc(p);
		}
		for( typename BlockList::iterator it=m_BSubject.m_List.begin(), end=m_BSubject.m_List.end(); it != end; )
		{
			Block* p = &it;
			it = m_BSubject.m_List.erase(it);
			BAllocator::allocator().dealloc(p);
		}
	}

public:
	/// O[v݂o
	Group*		PopGroup(void)
	{
		if( m_GSubject.m_List.empty() )
		{
#if DYNAMIC_ALLOCATE
			IRIS_WARNING("dynamic allocate.");
			m_GSubject.m_List.push_back( reinterpret_cast<Group*>(GAllocator::allocator().alloc(1)) );
			return PopGroup();
#else
			return nullptr;
#endif
		}
		Group* p = m_GSubject.m_List.pop_back();
		m_GSubject.AttachObserver(p);
		return p;
	}
	/// O[vϊ
	void		PushGroup(Group* p)
	{
		m_GSubject.DetachObserver(p);
	}

	/// C݂o
	Line*		PopLine(void)
	{
		if( m_LSubject.m_List.empty() )
		{
#if DYNAMIC_ALLOCATE
			IRIS_WARNING("dynamic allocate.");
			m_LSubject.m_List.push_back( reinterpret_cast<Line* >(LAllocator::allocator().alloc(1)) );
			return PopLine();
#else
			return nullptr;
#endif
		}
		Line* p = m_LSubject.m_List.pop_back();
		m_LSubject.AttachObserver(p);
		return p;
	}
	/// Cϊ
	void		PushLine(Line* p)
	{
		m_LSubject.DetachObserver(p);
	}

	/// ubN݂o
	Block*		PopBlock(void)
	{
		if( m_BSubject.m_List.empty() )
		{
#if DYNAMIC_ALLOCATE
			IRIS_WARNING("dynamic allocate.");
			m_BSubject.m_List.push_back( reinterpret_cast<Block*>(BAllocator::allocator().alloc(1)) );
			return PopBlock();
#else
			return nullptr;
#endif
		}
		Block* p = m_BSubject.m_List.pop_back();
		m_BSubject.AttachObserver(p);
		return p;
	}
	/// ubNϊ
	void		PushBlock(Block* p)
	{
		m_BSubject.DetachObserver(p);
	}

	/// 
	void		WithDrawalGroup(void)
	{
		Group* p = m_GSubject.GetObserver();
		while( p != nullptr )
		{
			if( p->IsIndependent() ) { p->release(); }
			p = p->GetNext();
		}
	}
	/// 
	void		WithDrawalLine(void)
	{
		Line* p = m_LSubject.GetObserver();
		while( p != nullptr )
		{
			if( p->IsIndependent() ) { p->release(); }
			p = p->GetNext();
		}
	}
	/// 
	void		WithDrawalBlock(void)
	{
		Block* p = m_BSubject.GetObserver();
		while( p != nullptr )
		{
			if( p->IsIndependent() ) { p->release(); }
			p = p->GetNext();
		}
	}
	/// 
	void		WithDrawal(void)
	{
		WithDrawalGroup();
		WithDrawalLine();
		WithDrawalBlock();
	}

public:
	/// 󂫐̎擾
	s32			GetFreeGroupNum(void)	{ return m_GSubject.m_List.size(); }
	/// 󂫐̎擾
	s32			GetFreeLineNum(void)	{ return m_LSubject.m_List.size(); }
	/// 󂫐̎擾
	s32			GetFreeBlockNum(void)	{ return m_BSubject.m_List.size(); }
};


/// xubN
template<typename _TN>
class CLabelBlock : public CListNodeBase, public CObserver< CLabelBlock<_TN> >
{
	typedef CObserver< CLabelBlock<_TN> >	_Observer;
public:
	typedef _TN		value_type;
private:
	value_type	m_Min;	//!< ŏʒu
	value_type	m_Max;	//!< őʒu
public:
	/// RXgN^
	CLabelBlock(void)
		: m_Min(0), m_Max(0) {}
public:
	/// ݒ
	void			Set(value_type min, value_type max)	{ m_Min = min; m_Max = max; }
	/// ŏʒu̐ݒ
	void			SetMin(value_type min)		{ m_Min = min; }
	/// őʒu̐ݒ
	void			SetMax(value_type max)		{ m_Max = max; }
	/// ŏʒu̎擾
	value_type		GetMin(void)				{ return m_Min; }
	/// őʒu̎擾
	value_type		GetMax(void)				{ return m_Max; }
	/// sNZ̎擾
	u32				GetPixels(void)				{ return static_cast<u32>(m_Max - m_Min + 1); }
	/// xOς݂ǂ
	bool			IsLabeling(void)			{ return is_link() && (_Observer::GetSubject() != nullptr); }
	/// ǂ
	bool			IsIndependent(void)			{ return !is_link() && (_Observer::GetSubject() != nullptr); }
	/// 󂫃Xgǂ
	bool			IsEmptyList(void)			{ return is_link() && (_Observer::GetSubject() == nullptr); }
public:
	virtual void	erase(void)
	{
		_Observer::release();
	}
};

/// xCNX
template<typename _TN>
class CLabelLine : public CListNodeBase, public CObserver< CLabelLine<_TN> >
{
	typedef CLabelLine<_TN>					_Myt;
	typedef CObserver< CLabelLine<_TN> >	_Observer;
public:
	typedef _TN		value_type;
	typedef CLabelBlock<_TN>	Block;
	typedef CList<Block>		BlockList;
private:
	value_type		m_Line;	//!< C
	BlockList		m_Blk;	//!< ubN
public:
	/// RXgN^
	CLabelLine(void)
		: m_Line(0)
	{}
public:
	/// ubN̎擾
	BlockList&		GetBlock(void)				{ return m_Blk; }
	/// Cԍ̐ݒ
	void			SetLine(value_type line)	{ m_Line = line; }
	/// Cԍ̎擾
	value_type		GetLine(void)				{ return m_Line; }
	/// ŏʒu̐ݒ
	void			SetMin(value_type min)
	{
		if( m_Blk.empty() )	return;
		m_Blk.begin()->SetMin(min);
	}
	/// őʒu̐ݒ
	void			SetMax(value_type max)
	{
		if( m_Blk.empty() )	return;
		m_Blk.back()->SetMax(max);
	}
	/// ŏʒu̎擾
	value_type		GetMin(void)
	{
		if( m_Blk.empty() )	return 0;
		return m_Blk.begin()->GetMin();
	}
	/// őʒu̎擾
	value_type		GetMax(void)
	{
		if( m_Blk.empty() )	return 0;
		return m_Blk.back()->GetMax();
	}
	/// sNZ̎擾
	u32				GetPixels(void)
	{
		u32 pixels = 0;
		for( typename BlockList::iterator it = m_Blk.begin(), end = m_Blk.end(); it != end; ++it )
		{
			pixels += it->GetPixels();
		}
		return pixels;
	}
	/// xOς݂ǂ
	bool			IsLabeling(void)			{ return is_link() && (_Observer::GetSubject() != nullptr); }
	/// ǂ
	bool			IsIndependent(void)			{ return !is_link() && (_Observer::GetSubject() != nullptr); }
	/// 󂫃Xgǂ
	bool			IsEmptyList(void)			{ return is_link() && (_Observer::GetSubject() == nullptr); }
public:
	/// x̘A
	void	Connect(_Myt* line)
	{
		typename BlockList::iterator it1 = m_Blk.begin(), end1 = m_Blk.end();
		typename BlockList::iterator it2 = line->m_Blk.begin(), end2 = line->m_Blk.end();
		for( ; it1 != end1 && it2 != end2; )
		{
			if( it1->GetMin() > it2->GetMax() )
			{
				Block* p = &it2;
				++it2;
				p->unlink();
				m_Blk.insert(it1, p);
			}
			else
			{
				while( it1->GetMin() > it2->GetMax() )
				{
					++it1;
					if( it1 == end1 ) break;
				}
				Block* p = &it2;
				++it2;
				p->unlink();
				m_Blk.insert(it1, p);
			}
		}
		for( ; it2 != end2; )
		{
			Block* p = &it2;
			++it2;
			p->unlink();
			m_Blk.push_back(p);
		}
		IRIS_ASSERT( !m_Blk.empty() );
		IRIS_ASSERT( line->m_Blk.empty() );
	}
	/// A\ǂ
	bool	IsLineConnect(Block* blk)
	{
		value_type min2 = blk->GetMin();
		value_type max2 = blk->GetMax();
		if( GetMin() > max2+1 || GetMax()+1 < min2 ) return false;
		IRIS_ASSERT( blk != nullptr );
		for( typename BlockList::iterator it = m_Blk.begin(), end = m_Blk.end(); it != end; ++it )
		{
			value_type min1 = it->GetMin();
			value_type max1 = it->GetMax();

			if( min1 <= max2+1 && max1+1 >= min2 ) return true;
		}
		return false;
	}
	/// \ǂ
	bool		IsConnect(_Myt* line)
	{
		IRIS_ASSERT( line != nullptr );
		for( typename BlockList::iterator it = line->m_Blk.begin(), end = line->m_Blk.end(); it != end; ++it )
		{
			if( IsLineConnect(&it) ) return true;
		}
		return false;
	}
public:
	virtual void	erase(void)
	{
		m_Blk.clear();
		_Observer::release();
	}
#ifdef _IRIS_DEBUG
public:
	bool	Dump(void)
	{
		//IRIS_ASSERT( !m_Blk.empty() );
		return true;
	}
#endif
};

/// xO[vNX
template<typename _TN>
class CLabelGroup : public CListNodeBase, public CObserver< CLabelGroup<_TN> >
{
	typedef CLabelGroup<_TN>				_Myt;
	typedef CObserver< CLabelGroup<_TN> >	_Observer;
public:
	typedef _TN		value_type;
	typedef CList<_Myt>			GroupList;
	typedef CLabelLine<_TN>		Line;
	typedef CList<Line>			LineList;
	typedef IrisTRect<_TN>		Rect;
private:
	LineList	m_Line;		//!< C
	u32			m_Label;	//!< x
	Rect		m_Box;		//!< oEfBO{bNX
public:
	// RXgN^
	CLabelGroup(void) : m_Label(0) {}

public:
	/// C擾
	LineList&	GetLine(void)		{ return m_Line; }
	/// J[̐ݒ
	void		SetLabel(u32 label)	{ m_Label = label; }
	/// J[̎擾
	u32			GetLabel(void)		{ return m_Label; }
	/// oEfBO{bNX̎擾
	Rect&		GetBox(void)		{ return m_Box; }
	/// [̎擾
	value_type	GetLeft(void)
	{
		if( m_Line.empty() ) return 0;
		value_type left = m_Line.begin()->GetMin();
		for( typename LineList::iterator it = m_Line.begin()++, end = m_Line.end(); it != end; ++it )
		{
			value_type min = it->GetMin();
			if( left > min ) left = min;
		}
		m_Box.left = left;
		return left;
	}
	/// [̎擾
	value_type	GetTop(void)		{ m_Box.top = m_Line.empty() ? 0 : m_Line.begin()->GetLine(); return m_Box.top; }
	/// E[̎擾
	value_type	GetRight(void)
	{
		if( m_Line.empty() ) return 0;
		value_type right = m_Line.begin()->GetMax();
		for( typename LineList::iterator it = m_Line.begin()++, end = m_Line.end(); it != end; ++it )
		{
			value_type max = it->GetMax();
			if( right < max ) right = max;
		}
		m_Box.right = right;
		return right;
	}
	/// [̎擾
	value_type	GetBottom(void)		{ m_Box.bottom = m_Line.empty() ? 0 : m_Line.back()->GetLine(); return m_Box.bottom; }

	/// xOς݂ǂ
	bool			IsLabeling(void)			{ return is_link() && (_Observer::GetSubject() != nullptr); }
	/// ǂ
	bool			IsIndependent(void)			{ return !is_link() && (_Observer::GetSubject() != nullptr); }
	/// 󂫃Xgǂ
	bool			IsEmptyList(void)			{ return is_link() && (_Observer::GetSubject() == nullptr); }
public:
	/// C̎擾
	Line*		GetLine(value_type y)
	{
		for( typename LineList::iterator it = m_Line.begin(), end = m_Line.end(); it != end; ++it )
		{
			if( it->GetLine() == y ) return &it;
		}
		return nullptr;
	}
	/// sNZ̎擾
	u32			GetPixels(void)
	{
		u32 pixels = 0;
		for( typename LineList::iterator it = m_Line.begin(), end = m_Line.end(); it != end; ++it )
		{
			pixels += it->GetPixels();
		}
		return pixels;
	}

public:
	/// x̘A
	void	Connect(_Myt* label)
	{
		IRIS_ASSERT( label != nullptr );
		typename LineList::iterator it1 = m_Line.begin(), end1 = m_Line.end();
		typename LineList::iterator it2 = label->m_Line.begin(), end2 = label->m_Line.end();
		for( ; it1 != end1 && it2 != end2; )
		{
			Line* p = &it2;
			++it2;
			p->unlink();
			if( it1->GetLine() == p->GetLine() )
			{
				// ꃉC
				it1->Connect(p);
				p->release();
			}
			else
			{
				while( it1->GetLine() < p->GetLine() )
				{
					++it1;
				}
				if( it1->GetLine() == p->GetLine() )
				{
					// ꃉC
					it1->Connect(p);
					p->release();
				}
				else
				{
					m_Line.insert(it1, p);
				}
			}
		}
		for( ; it2 != end2; )
		{
			Line* p = &it2;
			++it2;
			p->unlink();
			m_Line.push_back(p);
		}
	}

public:
	virtual void	erase(void)
	{
		m_Line.clear();
		_Observer::release();
	}

#ifdef _IRIS_DEBUG
public:
	bool	Dump(void)
	{
		if( m_Line.size() < 2 ) return true;
		value_type line = GetTop(), tmp;
		for( typename LineList::iterator it = ++m_Line.begin(), end = m_Line.end(); it != end; ++it )
		{
			tmp = it->GetLine();
			IRIS_ASSERT( tmp == line+1 );
			it->Dump();
			line = tmp;
		}
		return true;
	}
#endif
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
