//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSequence.cpp
 * @brief		V[PXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndSequence_CPP_

//======================================================================
// include
#include "FndSequence.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
// CSequenceData
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSequenceData::CSequenceData(void)
: m_pSeqData(nullptr)
{
}

/**********************************************************************//**
 *
 * f[^̓ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	pData	= V[PXf[^
 * @return 
*//***********************************************************************/
bool CSequenceData::Load(LPSEQDATA pData)
{
	Unload();
	if( pData == nullptr ) return false;
	// AhXɕϊ
	m_pSeqData = pData;
	m_pSeqData->pKeys = (LPSEQKEY)((u8*)pData + pData->key_offset);
	for( s32 i=0, n=pData->key_num; i < n; ++i )
	{
		m_pSeqData->pKeys[i].pData = (void*)((u8*)pData + m_pSeqData->pKeys[i].offset);
	}
	m_pSeqData->pUser = (pData->user_offset != 0) ? (void*)((u8*)pData + pData->user_offset) : nullptr;
	return true;
}

/**********************************************************************//**
 *
 * f[^̓ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	buf	= t@Cobt@
 * @param [in]	idx	= V[PXf[^̃CfbNX
 * @return 
*//***********************************************************************/
bool CSequenceData::LoadFile(void* buf, s32 idx)
{
#ifndef _IRIS_SUPPORT_MULTI_SEQUENCE_FILE
	(void)idx;	// unused
#endif

	if( buf == nullptr ) return false;

	// wb_̊mF
	LPSEQHEAD head = (LPSEQHEAD)buf;
	if( head->major_id != SEQ_MAJOR_ID ) return false;
	if( head->minor_id != GetMinorID() ) return false;
	if( head->major_ver != SEQ_MAJOR_VERSION ) return false;
	if( head->minor_ver != GetMinorVersion() ) return false;

#ifdef _IRIS_SUPPORT_MULTI_SEQUENCE_FILE
	if( idx >= head->seq_num ) return false;
	LPSEQDATA pSeq = (LPSEQDATA)((u8*)buf + head->seq_offset);
	LPSEQDATA pData = pSeq + idx;
#else
	LPSEQDATA pData = (LPSEQDATA)(head+1);
#endif
	return Load(pData);
}


// ISequence
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
ISequence::ISequence(void)
: m_pData(nullptr), m_CurrTime(XF32_ZERO), m_Speed(XF32_ONE)
{
}

/**********************************************************************//**
 *
 * XV
 *
*//***********************************************************************/
void ISequence::Update(void)
{
	xf32 prev_time;
	xf32 new_time;
	prev_time = m_CurrTime;	// O̎
	Step();					// Ԍo
	new_time = m_CurrTime;	// ̎
	update(prev_time, new_time);
}

/**********************************************************************//**
 *
 * XV
 *
 -----------------------------------------------------------------------
 * @param [in]	prev_time	= ȑO̎
 * @param [in]	new_time	= ݂̎
*//***********************************************************************/
void ISequence::update(xf32 prev_time, xf32 new_time)
{
	s32 i, n;
	const SEQKEY*	key;
	if( m_pData == nullptr ) return;

	if( new_time > prev_time )
	{
		for( i=0, n = m_pData->GetKeyNum(), key = m_pData->GetKeys(); i < n; ++i, ++key )
		{
			if( key->type == eSEQKEY_TYPE_NULL ) continue;
			if( key->time > new_time ) continue;

			if( (key->time > prev_time) )
			{
				Proc(*key);
			}
			else if( key->time == XF32_ZERO )
			{
				if( (key->time >= prev_time) )
				{
					Proc(*key);
				}
			}
		}
	}
	else
	{
		// tĐ
		for( i=0, n=m_pData->GetKeyNum(), key = m_pData->GetKeys(); i < n; ++i, ++key )
		{
			if( key->type == eSEQKEY_TYPE_NULL ) continue;
			if( (key->time >= prev_time) && (key->time < new_time) )
			{
				Proc(*key);
			}
		}
	}
}

}	// end of namespace fnd
}	// end of namespace iris
