//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CgProgram.cpp
 * @brief		Cg SDK vONXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CgProgram_CPP_

//======================================================================
// include
#include "CgProgram.h"

#ifdef _IRIS_SUPPORT_CG
#include "../../iris_debug.h"

namespace iris {
namespace gx {
namespace cg
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCgProgram::CCgProgram(void)
: m_Program(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	rProg	= Rs[
*//***********************************************************************/
CCgProgram::CCgProgram(CCgProgram& rProg)
: m_Program(nullptr)
{
	Copy(rProg);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCgProgram::~CCgProgram(void)
{
	Delete();
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	Context		= ReLXg
 * @param [in]	pFileName	= t@C
 * @param [in]	pEntry		= VF[_[̃Gg֐
 * @param [in]	pArgs		= 
 * @return	
*//***********************************************************************/
bool CCgProgram::Create(CGcontext Context, LPCSTR pFileName, CGprofile Profile
						, LPCSTR pEntry, LPCSTR* pArgs)
{
	IRIS_ASSERT( m_Program == nullptr );
	m_Program = cgCreateProgramFromFile(Context, CG_SOURCE
		, pFileName, Profile, pEntry, pArgs);
	if( m_Program == nullptr ) return false;
	return true;
}

/**********************************************************************//**
 *
 * t@C쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	Context		= ReLXg
 * @param [in]	pProgram	= vO
 * @param [in]	pEntry		= VF[_[̃Gg֐
 * @param [in]	pArgs		= 
 * @return	
*//***********************************************************************/
bool CCgProgram::CreateFromFile(CGcontext Context, LPCSTR pProgram, CGprofile Profile
								, LPCSTR pEntry, LPCSTR* pArgs)
{
	IRIS_ASSERT( m_Program == nullptr );
	m_Program = cgCreateProgram(Context, CG_SOURCE
		, pProgram, Profile, pEntry, pArgs);
	if( m_Program == nullptr ) return false;
	return true;
}

/**********************************************************************//**
 *
 * 폜
 *
*//***********************************************************************/
void CCgProgram::Delete(void)
{
	cgDestroyProgram(m_Program);
	m_Program = nullptr;
}

/**********************************************************************//**
 *
 * Rs[
 *
 -----------------------------------------------------------------------
 * @param [in]	rProg	= Rs[
 * @return	
*//***********************************************************************/
bool CCgProgram::Copy(CCgProgram& rProg)
{
	CGprogram prog = cgCopyProgram(rProg.m_Program);
	if( prog == nullptr ) return false;
	Delete();
	m_Program = prog;
	return true;
}

/**********************************************************************//**
 *
 * vOꂽReLXg̎擾
 *
 -----------------------------------------------------------------------
 * @return	ReLXg
*//***********************************************************************/
CGcontext CCgProgram::GetContext(void) const
{
	return cgGetProgramContext(m_Program);
}

}	// end of namespace cg
}	// end of namespace gx
}	// end of namespace iris

#endif
