//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CgProgram.h
 * @brief		Cg SDK vONXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CgProgram_H_
#define INCG_IRIS_CgProgram_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_CG
#include "cg_inchead.h"
#include "../../iris_object.h"

namespace iris {
namespace gx {
namespace cg
{

//======================================================================
// class
/**
 * @ingroup	Cg
 * @brief	Cg vONX
*/
class CCgProgram : private INonCopyable<>
{
private:
	CGprogram	m_Program;	//!< vO
public:
	// RXgN^
	CCgProgram(void);
	// RXgN^
	CCgProgram(CCgProgram& rProg);
	// fXgN^
	~CCgProgram(void);

public:
	/// Rs[
	CCgProgram&	operator = (CCgProgram& rProg)	{ Copy(rProg); return *this; }

public:
	// 쐬
	bool		Create(CGcontext Context, LPCSTR pFileName, CGprofile Profile
							, LPCSTR pEntry, LPCSTR* pArgs);
	// t@C쐬
	bool		CreateFromFile(CGcontext Context, LPCSTR pProgram, CGprofile Profile
							, LPCSTR pEntry, LPCSTR* pArgs);
	// 폜
	void		Delete(void);

public:
	// Rs[
	bool		Copy(CCgProgram& prog);

public:
	// vO̎擾
	CGprogram	GetProgram(void)	{ return m_Program; }
	// vOꂽReLXg̎擾
	CGcontext	GetContext(void) const;
};

}	// end of namespace cg
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
