//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvLine.h
 * @brief		CvLine t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvLine_H_
#define INCG_IRIS_CvLine_H_

//======================================================================
// include
#include "../../../fnd/container/FndIterator.h"
#include "../cv_inchead.h"
#include "../../../iris_debug.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	Line Iterator NX
*/
class CCvLineIteratorBase : public fnd::IIteratorBase<CvLineIterator>
{
	typedef fnd::IIteratorBase<CvLineIterator>		_Mybase;

protected:
	CvLineIterator	m_Ite;	//!< 
public:
	//! RXgN^
	CCvLineIteratorBase(void)	{ m_pNode = &m_Ite; }
	//! RXgN^
	CCvLineIteratorBase(node_ptr node) { m_pNode = &m_Ite; m_Ite = *node; }

protected:
	/// ̃m[hɐi߂
	void	inc(void)
	{
		CV_NEXT_LINE_POINT(*m_pNode);
	}
	/// Õm[hɖ߂
	void	dec(void)
	{
		IRIS_ASSERT(!"߂܂");
	}
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
