//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvSequence.h
 * @brief		CvSequence t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvSequence_H_
#define INCG_IRIS_CvSequence_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "../cv_inchead.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	V[PX NX
*/
template<typename TN>
class CCvSeq : public IIrisObject
{
	typedef TN	value_type;
	typedef TN	*value_ptr;
	typedef TN	&value_ref;

	typedef CCvSeq<TN>	_Myt;
protected:
	CvSeq*	m_pSeq;	//!< V[PX

public:
	// RXgN^
	CCvSeq(void) : m_pSeq(nullptr) {}
	CCvSeq(CvSeq* seq) : m_pSeq(seq) {}
	template<typename TT>
	CCvSeq(const CCvSeq<TT>& seq) : m_pSeq(seq.m_pSeq) {}
	// fXgN^
	~CCvSeq(void) {}

public:
	//! rebind
	template<typename TN2>struct rebind
	{
		typedef CCvSeq<TN2> type;
	};

public:

	/**
	 * @brief	vf̎擾
	*/
	value_ptr	GetElem(int index) const
	{
		return pointer_cast<value_ptr>(cvGetSeqElem(m_pSeq, index));
	}

	/**
	 * @brief	vf̎擾
	*/
	int			GetElemCount(void) const
	{
		return m_pSeq->total;
	}

	/**
	 * @brief	vf̃TCY擾
	*/
	int			GetElemSize(void) const
	{
		return m_pSeq->elem_size;
	}

public:
	/**
	 * @name	operator
	 * @{
	*/
			CvSeq*	operator -> (void)			{ return m_pSeq; }
	const	CvSeq*	operator -> (void)	const	{ return m_pSeq; }

	value_ref	operator [] (int index)	const	{ return *GetElem(index); }
	/**
	 * @}
	*/
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
