//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvCanny.h
 * @brief		Canny t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvCanny_H_
#define INCG_IRIS_CvCanny_H_

//======================================================================
// include
#include "../image/CvImage.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	Canny tB^NX
*/
class CCvCanny : public CCvImage
{
public:
	// RXgN^
	CCvCanny(void);
	CCvCanny(const CvArr* src, double threshold1, double threshold2
		, int aperture_size=3
		, int depth=IPL_DEPTH_8U, int channels=1);
	CCvCanny(const ::cv::Mat& src, double threshold1, double threshold2
		, int aperture_size=3
		, int depth=IPL_DEPTH_8U, int channels=1);
	// fXgN^
	~CCvCanny(void);

public:
	// o
	void	Detect(const CvArr* src, double threshold1, double threshold2,  int aperture_size=3);
	void	Detect(const ::cv::Mat& src, double threshold1, double threshold2,  int aperture_size=3);
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
