//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvHaar.cpp
 * @brief		Haar-Like  t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvHaar_CPP_

//======================================================================
// include
#include "CvHaar.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvHaar::CCvHaar(void)
: m_pCascade(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvHaar::~CCvHaar(void)
{
	Release();
}

/**********************************************************************//**
 *
 * õ[h
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszFileName	= t@C
 * @return	
*//***********************************************************************/
bool CCvHaar::Load(LPCSTR lpszFileName)
{
	Release();
	m_pCascade = pointer_cast<CvHaarClassifierCascade*>(cvLoad(lpszFileName));
	return m_pCascade != nullptr;
}

/**********************************************************************//**
 *
 * o
 *
 -----------------------------------------------------------------------
 * @param [in]	image			= C[W
 * @param [in]	storage			= 
 * @param [in]	scale_factor	= 
 * @param [in]	min_neighbors	= 
 * @param [in]	flags			= 
 * @param [in]	min_size		= 
 * @param [in]	max_size		= 
 * @return	
*//***********************************************************************/
CvSeq* CCvHaar::Detect(const CvArr* image, CvMemStorage* storage
					   , double scale_factor, int min_neighbors, int flags
					   , CvSize min_size, CvSize max_size)
{
	if( m_pCascade == nullptr ) return nullptr;
	return cvHaarDetectObjects(image, m_pCascade, storage, scale_factor, min_neighbors, flags, min_size, max_size);
}
/// @ref	Detect
CvSeq* CCvHaar::Detect(const cv::Mat& image, CvMemStorage* storage
					   , double scale_factor, int min_neighbors, int flags
					   , CvSize min_size, CvSize max_size)
{
	if( m_pCascade == nullptr ) return nullptr;
	CvMat mat = image;
	return cvHaarDetectObjects(&mat, m_pCascade, storage, scale_factor, min_neighbors, flags, min_size, max_size);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CCvHaar::Release(void)
{
	if( m_pCascade != nullptr )
	{
		cvReleaseHaarClassifierCascade(&m_pCascade);
		m_pCascade = nullptr;
	}
}

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../gui/CvWindow.h"
#include "../image/CvImage.h"
#include "../core/CvSequence.h"
#include "../memory/CvMemStorage.h"
#include "../../../iris_using.h"
#include "../../../iris_iostream.h"
#include <stdio.h>
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CCvHaarUnitTest, Func)
{
	CCvHaar haar;
	CCvImage image;
	CCvMemStorage storage(0);
	CCvWindow window;
	CHAR path[MAX_PATH];
	std::cout << "ot@C͂ĂB" << std::endl;
	std::cin.getline(path, MAX_PATH);

	if( !haar.Load(path) ) return;

	std::cout << "oΏۃt@C͂ĂB" << std::endl;
	std::cin.getline(path, MAX_PATH);
	if( !image.Load(path) ) return;

	std::cout << "Do detect..." << std::endl;
	CCvSeq<CvRect> seq = haar.Detect(image, storage);

	for( int i=0; i < seq.GetElemCount(); ++i )
	{
		CvRect rect = seq[i];
		image.DrawRectangle(cvPoint(rect.x, rect.y)
			, cvPoint((rect.x+rect.width), (rect.y+rect.height))
			, CV_RGB(255, 0, 0), 3);
	}

	window.Create("Show Image");
	window.ShowImage(image);
	cvWaitKey();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
