//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvLaplace.cpp
 * @brief		CvLaplace t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvLaplace_CPP_

//======================================================================
// include
#include "CvLaplace.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvLaplace::CCvLaplace(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= C[W
 * @param [in]	aperture_size	= 
*//***********************************************************************/
CCvLaplace::CCvLaplace(const CvArr* src, int aperture_size
				   , int depth, int channels)
{
	Create(cvGetSize(src), depth, channels);
	Detect(src, aperture_size);
}
CCvLaplace::CCvLaplace(const cv::Mat& src, int aperture_size
				   , int depth, int channels)
{
	CvMat mat = src;
	Create(cvGetSize(&mat), depth, channels);
	Detect(src, aperture_size);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvLaplace::~CCvLaplace(void)
{
}

/**********************************************************************//**
 *
 * o
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= C[W
 * @param [in]	aperture_size	= 
 * @param [in]	scale			= XP[
 * @param [in]	delta			= 
 * @param [in]	borderType		= 
*//***********************************************************************/
void CCvLaplace::Detect(const CvArr* src, int aperture_size
						, double scale, double delta, int borderType)

{
	cv::Mat mat = cv::cvarrToMat(src);
	Detect(mat, aperture_size, scale, delta, borderType);
}
/// @ref Detect
void CCvLaplace::Detect(const cv::Mat& src, int aperture_size
						, double scale, double delta, int borderType)
{
	try
	{
		::cv::Laplacian(src, m_Mat, m_Mat.depth(), aperture_size, scale, delta, borderType);
	}
	catch (...)
	{
		CCvImage gray;
		CCvImage temp;
		gray.TranslateColor(src, CV_BGR2GRAY, 1);
		temp.Create(gray.GetSize(), IPL_DEPTH_16S, 1);
		::cv::Laplacian(gray, temp, temp.GetMat().depth(), aperture_size, scale, delta, borderType);

		Convert(temp);
	}
}

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../gui/CvWindow.h"
#include "../memory/CvMemStorage.h"
#include "../../../iris_using.h"
#include "../../../iris_iostream.h"
#include <stdio.h>
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CCvLaplaceUnitTest, Func)
{
	CCvImage image;
	CCvWindow window;
	CHAR path[MAX_PATH];
	std::cout << "Jt@C͂ĂB" << std::endl;
	std::cin.getline(path, MAX_PATH);

	if( !image.Load(path) ) return;

	CCvLaplace laplace(image);

	window.Create("Show Image");
	window.ShowImage(laplace);
	cvWaitKey();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
