//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvTrackbar.h
 * @brief		OpenCV gbNo[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvTrackbar_H_
#define INCG_IRIS_CvTrackbar_H_

//======================================================================
// include
#include "CvWindow.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	OpenCV gbNo[NX
*/
class CCvTrackbar : public CCvWindow
{
protected:
	string	m_TrackbarName;
	int		m_Pos;		//!< ʒu
	LPVOID	m_pUser;	//!< [U[f[^
public:
	// RXgN^
	CCvTrackbar(void);
	// fXgN^
	virtual ~CCvTrackbar(void);

public:
	// 쐬
			bool	Create(LPCSTR lpszTrackbarName, LPCSTR lpszWindowName, int count, void* pUser);
	// 
	virtual void	Close(void);

public:
	//! ʒu̎擾
	int		GetPos(void)	{ return m_Pos; }
	// ʒu̐ݒ
	void	SetPos(int pos);

protected:
	/// R[obN֐
	virtual void	OnCallback(int pos, void* userdata) { IRIS_UNUSED_VARIABLE(pos); IRIS_UNUSED_VARIABLE(userdata); }

private:
	// R[obN֐
	static	void	_OnCallback(int pos, void* userdata);
};


}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
