//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvWindow.h
 * @brief		OpenCV Window t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvWindow_H_
#define INCG_IRIS_CvWindow_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "../cv_inchead.h"

#ifdef _IRIS_SUPPORT_OPENCV
#include <opencv/highgui.h>

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	OpenCV EBhENX
*/
class CCvWindow : private INonCopyable<CCvWindow>
{
protected:
	cvHWND	m_hWnd;		//!< EBhEnh
public:
	// RXgN^
	CCvWindow(void);
	explicit CCvWindow(cvHWND wnd);
	// fXgN^
	virtual ~CCvWindow(void);

public:
	// A^b`
	bool	Attach(cvHWND hWnd);
	// f^b`
	cvHWND	Detach(void);

public:
	// 쐬
			bool	Create(LPCSTR lpszName, int flags = CV_WINDOW_AUTOSIZE);
	// 
	virtual void	Close(void);

public:
	// ړ
	void	Move(int x, int y);

public:
	// C[W̕\
	void	ShowImage(const ::cv::Mat& image);

	// EBhE̎擾
	LPCSTR	GetWindowName(void)	const;

protected:
	// EBhE쐬̏
	bool	OnCreate(LPCSTR lpszName);
};


}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
