//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvConvKernel.cpp
 * @brief		OpenCv Matrix t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvConvKernel_CPP_

//======================================================================
// include
#include "CvConvKernel.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvConvKernel::CCvConvKernel(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	rows		= s
 * @param [in]	cols		= 
 * @param [in]	anchor_x	= 
 * @param [in]	anchor_y	= 
 * @param [in]	shape		= `(CV_SHAPE_***)
 * @param [in]	values		= 
 *//***********************************************************************/
CCvConvKernel::CCvConvKernel(int rows, int cols, int anchor_x, int anchor_y, int shape, int* values)
{
	Create(rows, cols, anchor_x, anchor_y, shape, values);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	rows		= s
 * @param [in]	cols		= 
 * @param [in]	anchor_x	= 
 * @param [in]	anchor_y	= 
 * @param [in]	shape		= `(CV_SHAPE_***)
 * @param [in]	values		= 
*//***********************************************************************/
bool CCvConvKernel::Create(int rows, int cols, int anchor_x, int anchor_y, int shape, int* values)
{
	m_object = cvCreateStructuringElementEx(cols, rows, anchor_x, anchor_y, shape, values);
	return is_valid();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CCvConvKernel::Release(void)
{
	cvReleaseStructuringElement( &m_object );
	m_object = nullptr;
}

/**********************************************************************//**
 *
 * ϊ
 *
 -----------------------------------------------------------------------
 * @param [out]	dst		= o
 * @param [out]	anchor	= 
*//***********************************************************************/
void CCvConvKernel::Convert(cv::Mat& dst, cv::Point& anchor) const
{
	Convert(m_object, dst, anchor);
}

/**********************************************************************//**
 *
 * ϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	src		= 
 * @param [out]	dst		= 
 * @param [out]	anchor	= 
*//***********************************************************************/
void CCvConvKernel::Convert(const IplConvKernel* src, cv::Mat& dst, cv::Point& anchor)
{
	if(src == nullptr)
	{
		anchor = cv::Point(1, 1);
		dst.release();
		return;
	}
	anchor = cv::Point(src->anchorX, src->anchorY);
	dst.create(src->nRows, src->nCols, CV_8U);

	int i, size = src->nRows*src->nCols;
	for( i = 0; i < size; i++ )
		dst.data[i] = (uchar)src->values[i];
}

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif
