//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvConvKernel.h
 * @brief		OpenCv Matrix t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvConvKernel_H_
#define INCG_IRIS_CvConvKernel_H_

//======================================================================
// include
#include "../../../fnd/container/FndWrapObject.h"
#include "../cv_inchead.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	Matrix NX
*/
class CCvConvKernel : public fnd::CWrapObject<IplConvKernel*>
{
public:
	// RXgN^
	CCvConvKernel(void);
	CCvConvKernel(int rows, int cols, int anchor_x, int anchor_y, int shape, int* values=nullptr);

public:
	// 쐬
	bool	Create(int rows, int cols, int anchor_x, int anchor_y, int shape, int* values=nullptr);
	// 
	void	Release(void);

public:
	// ϊ
	void	Convert(cv::Mat& dst, cv::Point& anchor) const;
	// ϊ
	static	void	Convert(const IplConvKernel* src, cv::Mat& dst, cv::Point& anchor);
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
