//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvFont.cpp
 * @brief		CvFont t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvFont_CPP_

//======================================================================
// include
#include "CvFont.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvFont::CCvFont(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	font_face	= tFCX(CV_FONT_HERSHEY***)
 * @param [in]	hscale		= XP[
 * @param [in]	hscale		= XP[
 * @param [in]	shear		= 
 * @param [in]	thickness	= 
 * @param [in]	line_type	= C^Cv
*//***********************************************************************/
CCvFont::CCvFont(int font_face, double hscale, double vscale
				 , double shear/* =0 */, int thickness/* =1 */, int line_type/* =8 */)
{
	Create(font_face, hscale, vscale, shear, thickness, line_type);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	font_face	= tFCX(CV_FONT_HERSHEY***)
 * @param [in]	scale		= XP[
 * @param [in]	thickness	= 
 * @param [in]	line_type	= C^Cv
*//***********************************************************************/
CCvFont::CCvFont(int font_face, double scale, int thickness/* =1 */, int line_type/* =8 */)
{
	Create(font_face, scale, thickness, line_type);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvFont::~CCvFont(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	font_face	= tFCX(CV_FONT_HERSHEY***)
 * @param [in]	hscale		= XP[
 * @param [in]	hscale		= XP[
 * @param [in]	shear		= 
 * @param [in]	thickness	= 
 * @param [in]	line_type	= C^Cv
*//***********************************************************************/
void CCvFont::Create(int font_face, double hscale, double vscale
					 , double shear/* =0 */, int thickness/* =1 */, int line_type/* =8 */)
{
	cvInitFont(&m_Font, font_face, hscale, vscale, shear, thickness, line_type);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	font_face	= tFCX(CV_FONT_HERSHEY***)
 * @param [in]	scale		= XP[
 * @param [in]	thickness	= 
 * @param [in]	line_type	= C^Cv
*//***********************************************************************/
void CCvFont::Create(int font_face, double scale, int thickness/* =1 */, int line_type/* =8 */)
{
	Create(font_face, scale, scale, 0.0, thickness, line_type);
}

/**********************************************************************//**
 *
 * eLXgTCY擾
 *
 -----------------------------------------------------------------------
 * @param [in]	text		= ؕ
 * @param [out]	text_size	= 
 * @param [out]	baseline	= x[XC
*//***********************************************************************/
void CCvFont::GetTextSize(LPCSTR text, CvSize* text_size, int* baseline) const
{
	cvGetTextSize(text, &m_Font, text_size, baseline);
}

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif
