//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvIplImage.cpp
 * @brief		OpenCV Image t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvIplImage_CPP_

//======================================================================
// include
#include "CvIplImage.h"
#include "iris_debug.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvIplImage::CCvIplImage(void)
: m_pImage(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvIplImage::CCvIplImage(const cv::Mat& mat)
: m_pImage(nullptr)
{
	Clone(mat);
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvIplImage::CCvIplImage(const CCvIplImage& rhs)
: m_pImage(nullptr)
{
	IplImage* pImage = cvCloneImage(rhs);
	Attach(pImage);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvIplImage::~CCvIplImage(void)
{
	Release();
}

/**********************************************************************//**
 *
 * C[W̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	size		= TCY
 * @param [in]	depth		= [x
 * @param [in]	channels	= `l
 * @return	
*//***********************************************************************/
bool CCvIplImage::Create(const CvSize& size, int depth, int channels)
{
	Release();
	IplImage* pImage = cvCreateImage(size, depth, channels);
	if( pImage == nullptr ) return false;
	Attach(pImage);
	return true;
}

/**********************************************************************//**
 *
 * }gbNXC[W̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	mat		= }gbNX
 * @return	
*//***********************************************************************/
bool CCvIplImage::CreateFromMatrix(const cv::Mat& mat)
{
	Release();
	IplImage* pImage = cvCreateImage(mat.size(), GetIplDepth(mat.depth()), mat.channels());
	if( pImage == nullptr ) return false;
	Attach(pImage);
	return true;
}

/**********************************************************************//**
 *
 * C[W̃[h
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszPath	= pX
 * @param [in]	flags		= tO
 * @return	
*//***********************************************************************/
bool CCvIplImage::Load(LPCSTR lpszPath, int flags)
{
	Release();
	IplImage* pImage = cvLoadImage(lpszPath, flags);
	if( pImage == nullptr )
	{
		return false;
	}
	Attach(pImage);
	return true;
}

/**********************************************************************//**
 *
 * C[W̕ۑ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszPath	= pX
 * @param [in]	params		= p[^[
 * @return	
*//***********************************************************************/
bool CCvIplImage::Save(LPCSTR lpszPath, const int* params) const
{
	return IRIS_TO_bool(cvSaveImage(lpszPath, GetCvArr(), params));
}

/**********************************************************************//**
 *
 * N[
 *
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
void CCvIplImage::Clone(const cv::Mat& src)
{
	Release();
	IplImage image = src;
	IplImage* pImage = cvCloneImage(&image);
	Attach(pImage);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CCvIplImage::Release(void)
{
	IplImage* pImage = Detach();
	cvReleaseImage(&pImage);
}

/**********************************************************************//**
 *
 * LȃC[Wǂ
 *
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CCvIplImage::IsValid(void) const
{
	return m_pImage != nullptr;
}

/**********************************************************************//**
 *
 * C[WTCY̎擾
 *
 -----------------------------------------------------------------------
 * @return	C[WTCY
*//***********************************************************************/
CvSize CCvIplImage::GetSize(void) const
{
	return cvSize(m_pImage->width, m_pImage->height);
}

/**********************************************************************//**
 *
 * C[W̎擾
 *
 -----------------------------------------------------------------------
 * @return	C[W
*//***********************************************************************/
s32 CCvIplImage::GetWidth(void) const
{
	return m_pImage->width;
}

/**********************************************************************//**
 *
 * C[W̎擾
 *
 -----------------------------------------------------------------------
 * @return	C[W
*//***********************************************************************/
s32 CCvIplImage::GetHeight(void) const
{
	return m_pImage->height;
}

/**********************************************************************//**
 *
 * [xtO̎擾
 *
 -----------------------------------------------------------------------
 * @return	[xtO
*//***********************************************************************/
int CCvIplImage::GetDepthFlag(void) const
{
	return -1;	// TODO : Ή
}

/**********************************************************************//**
 *
 * [x̎擾
 *
 -----------------------------------------------------------------------
 * @return	[x
*//***********************************************************************/
int CCvIplImage::GetDepth(void) const
{
	return m_pImage->depth;
}

/**********************************************************************//**
 *
 * `l̎擾
 *
 -----------------------------------------------------------------------
 * @return	`l
*//***********************************************************************/
int CCvIplImage::GetChannels(void) const
{
	return m_pImage->nChannels;
}

/**********************************************************************//**
 *
 * ㏑Rs[
 *
 -----------------------------------------------------------------------
 * @param [in]	src		= Rs[
 * @param [in]	mask	= }XN
*//***********************************************************************/
void CCvIplImage::Copy(const cv::Mat& src, const cv::Mat& mask)
{
	CvMat smat = src;
	CvMat mmat = mask;
	cvCopy(&smat, GetCvArr(), &mmat);
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [out]	dst0	= o̓`l0
 * @param [out]	dst1	= o̓`l1
 * @param [out]	dst2	= o̓`l2
 * @param [out]	dst3	= o̓`l3
*//***********************************************************************/
void CCvIplImage::Split(CvArr* dst0, CvArr* dst1, CvArr* dst2, CvArr* dst3) const
{
	cvSplit(GetCvArr(), dst0, dst1, dst2, dst3);
}

/**********************************************************************//**
 *
 * 臒l
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= Rs[
 * @param [in]	threshold		= 臒l
 * @param [in]	max_value		= ől
 * @param [in]	threshold_type	= @
*//***********************************************************************/
void CCvIplImage::Threshold(const cv::Mat& src, double threshold, double max_value, int threshold_type)
{
	CvMat smat = src;
	cvThreshold(&smat, GetCvArr(), threshold, max_value, threshold_type);
}

/**********************************************************************//**
 *
 * J[tH[}bg̕ϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	src			= 
 * @param [in]	code		= tO
*//***********************************************************************/
void CCvIplImage::TranslateColor(const cv::Mat& src, int code)
{
	CvMat smat = src;
	cvCvtColor(&smat, GetCvArr(), code);
}

/**********************************************************************//**
 *
 * ϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	src			= 
*//***********************************************************************/
void CCvIplImage::Convert(const cv::Mat& src)
{
	ConvertScale(src, 1.0);
}

/**********************************************************************//**
 *
 * `ϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	src			= 
 * @param [in]	scale		= XP[
 * @param [in]	shift		= 
*//***********************************************************************/
void CCvIplImage::ConvertScale(const cv::Mat& src, double scale, double shift)
{
	CvMat smat = src;
	cvConvertScale(&smat, GetCvArr(), scale, shift);
}

/**********************************************************************//**
 *
 * `ϊ(8rbg^̔zɕϊ)
 *
 -----------------------------------------------------------------------
 * @param [in]	src			= 
 * @param [in]	scale		= XP[
 * @param [in]	shift		= 
*//***********************************************************************/
void CCvIplImage::ConvertScaleAbs(const cv::Mat& src, double scale, double shift)
{
	CvMat smat = src;
	cvConvertScaleAbs(&smat, GetCvArr(), scale, shift);
}

/**********************************************************************//**
 *
 * XP[
 *
 -----------------------------------------------------------------------
 * @param [in]	scale		= XP[
 * @param [in]	shift		= 
*//***********************************************************************/
void CCvIplImage::Scale(double scale, double shift)
{
	cvConvertScale(GetCvArr(), GetCvArr(), scale, shift);
}

/**********************************************************************//**
 *
 * TCYύX
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	interpolation	= ϊ(CV_INTER_***)
*//***********************************************************************/
void CCvIplImage::Resize(const cv::Mat& src, int interpolation)
{
	CvMat smat = src;
	cvResize(&smat, GetCvArr(), interpolation);
}

/**********************************************************************//**
 *
 * TCYύX
 *
 -----------------------------------------------------------------------
 * @param [in]	width			= ϊ̕
 * @param [in]	height			= ϊ̍
 * @param [in]	interpolation	= ϊ(CV_INTER_***)
*//***********************************************************************/
void CCvIplImage::Resize(int width, int height, int interpolation)
{
	CCvIplImage temp = *this;
	Release();
	Create(cvSize(width, height), temp.GetDepth(), temp.GetChannels());
	cvResize(temp, GetCvArr(), interpolation);
}

/**********************************************************************//**
 *
 * AtBϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	matrix			= AtBs
 * @param [out]	flags			= tO
 * @param [in]	fillval			= 
*//***********************************************************************/
void CCvIplImage::WarpAffine(const cv::Mat& src, const cv::Mat& matrix, int flags, CvScalar fillval)
{
	if( !IsValid() ) CreateFromMatrix(src);
	CvMat smat = src;
	CvMat rot = matrix;
	cvWarpAffine(&smat, GetCvArr(), &rot, flags, fillval);
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	smoothtype		= ^Cv
 * @param [in]	size1			= 
 * @param [in]	size2			= 
 * @param [in]	sigma1			= 
 * @param [in]	sigma2			= 
*//***********************************************************************/
void CCvIplImage::Smooth(const cv::Mat& src, int smoothtype, int size1, int size2, double sigma1, double sigma2)
{
	if( !IsValid() ) CreateFromMatrix(src);
	CvMat smat = src;
	cvSmooth(&smat, GetCvArr(), smoothtype, size1, size2, sigma1, sigma2);
}

/**********************************************************************//**
 *
 * (CV_BLUR_NO_SCALE)
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	size1			= 
 * @param [in]	size2			= 
*//***********************************************************************/
void CCvIplImage::SmoothBlurNoScale(const cv::Mat& src, int size1, int size2)
{
	Smooth(src, CV_BLUR_NO_SCALE, size1, size2);
}

/**********************************************************************//**
 *
 * (CV_BLUR)
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	size1			= 
 * @param [in]	size2			= 
*//***********************************************************************/
void CCvIplImage::SmoothBlur(const cv::Mat& src, int size1, int size2)
{
	Smooth(src, CV_BLUR, size1, size2);
}

/**********************************************************************//**
 *
 * (CV_MEDIAN)
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	size			= TCY
*//***********************************************************************/
void CCvIplImage::SmoothMedian(const cv::Mat& src, int size)
{
	Smooth(src, CV_MEDIAN, size);
}

/**********************************************************************//**
 *
 * (CV_BILATERAL)
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	size1			= 
 * @param [in]	size2			= 
*//***********************************************************************/
void CCvIplImage::SmoothBilateral(const cv::Mat& src, int size1, int size2)
{
	Smooth(src, CV_BILATERAL, size1, size2);
}

/**********************************************************************//**
 *
 * (CV_BILATERAL)
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	size1			= 
 * @param [in]	size2			= 
 * @param [in]	sigma1			= 
 * @param [in]	sigma2			= 
*//***********************************************************************/
void CCvIplImage::SmoothGaussian(const cv::Mat& src, int size1/* =3 */, int size2/* =0 */, double sigma1/* =0 */, double sigma2/* =0 */)
{
	Smooth(src, CV_GAUSSIAN, size1, size2, sigma1, sigma2);
}

/**********************************************************************//**
 *
 * tB^[
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	kernel			= 
 * @param [in]	anchor			= 
*//***********************************************************************/
void CCvIplImage::Filter2D(const cv::Mat& src, const cv::Mat& kernel, const CvPoint& anchor)
{
	if( !IsValid() ) CreateFromMatrix(src);
	CvMat smat = src;
	CvMat kmat = kernel;
	cvFilter2D(&smat, GetCvArr(), &kmat, anchor);
}

/**********************************************************************//**
 *
 * tHW[ϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	tmp				= e|
 * @param [in]	element			= 
 * @param [in]	operation		= (CV_MOP_***)
 * @param [in]	iterations		= 
*//***********************************************************************/
void CCvIplImage::MorphologyEx(const cv::Mat& src, cv::Mat& tmp, IplConvKernel* element, int operation, int iterations)
{
	if( !IsValid() ) CreateFromMatrix(src);
	if( tmp.empty() ) tmp = src.clone();
	CvMat smat = src;
	CvMat tmat = tmp;
	cvMorphologyEx(&smat, GetCvArr(), &tmat, element, operation, iterations);
}

/**********************************************************************//**
 *
 * tHW[ϊ(Dilate)
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	element			= 
 * @param [in]	iterations		= 
*//***********************************************************************/
void CCvIplImage::MorphologyDilate(const cv::Mat& src, IplConvKernel* element, int iterations)
{
	if( !IsValid() ) CreateFromMatrix(src);
	CvMat smat = src;
	cvDilate(&smat, GetCvArr(), element, iterations);
}

/**********************************************************************//**
 *
 * tHW[ϊ(Erode)
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	element			= 
 * @param [in]	iterations		= 
*//***********************************************************************/
void CCvIplImage::MorphologyErode(const cv::Mat& src, IplConvKernel* element, int iterations)
{
	if( !IsValid() ) CreateFromMatrix(src);
	CvMat smat = src;
	cvErode(&smat, GetCvArr(), element, iterations);
}

/**********************************************************************//**
 *
 * 𑜓xAbv
 *
 -----------------------------------------------------------------------
 * @param [in]	src		= 
 * @param [in]	filter	= tB^[
*//***********************************************************************/
void CCvIplImage::PyrUp(const cv::Mat& src, int filter)
{
	CvMat smat = src;
	cvPyrUp(&smat, GetCvArr(), filter);
}

/**********************************************************************//**
 *
 * 𑜓x_E
 *
 -----------------------------------------------------------------------
 * @param [in]	src		= 
 * @param [in]	filter	= tB^[
*//***********************************************************************/
void CCvIplImage::PyrDown(const cv::Mat& src, int filter)
{
	CvMat smat = src;
	cvPyrDown(&smat, GetCvArr(), filter);
}

/**********************************************************************//**
 *
 * ̈敪
 *
 -----------------------------------------------------------------------
 * @param [in]	src			= 
 * @param [in]	storage		= 
 * @param [in]	comp		= 
 * @param [in]	level		= 
 * @param [in]	threshold1	= 
 * @param [in]	threshold2	= 
*//***********************************************************************/
void CCvIplImage::PyrSegmentation(const cv::Mat& src, CvMemStorage* storage, CvSeq** comp, int level, double threshold1, double threshold2)
{
	if( !IsValid() ) CreateFromMatrix(src);
	IplImage smat = src;
	cvPyrSegmentation(&smat, m_pImage, storage, comp, level, threshold1, threshold2);
}

/**********************************************************************//**
 *
 * ϒlVtgɂ摜̃ZOg
 *
 -----------------------------------------------------------------------
 * @param [in]	src			= 
 * @param [in]	sp			= 
 * @param [in]	sr			= 
 * @param [in]	max_level	= 
 * @param [in]	termcrit	= 
*//***********************************************************************/
void CCvIplImage::PyrMeanShiftFiltering(const cv::Mat& src, double sp, double sr, int max_level, CvTermCriteria termcrit)
{
	if( !IsValid() ) CreateFromMatrix(src);
	CvMat smat = src;
	cvPyrMeanShiftFiltering(&smat, GetCvArr(), sp, sr, max_level, termcrit);
}

/**********************************************************************//**
 *
 *
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	corners			= 
 * @param [out]	corner_count	= 
 * @param [in]	quality_level	= 
 * @param [in]	min_distance	= 
 * @param [in]	mask			= 
 * @param [in]	block_size		= 
 * @param [in]	use_harris		= 
 * @param [in]	k				= 
*//***********************************************************************/
void CCvIplImage::GoodFeaturesToTrack(const cv::Mat& src, CvPoint2D32f* corners, int* corner_count
								   , double quality_level, double min_distance
								   , const CvArr* mask, int block_size, int use_harris, double k)
{
	CvMat smat = src;
	CCvIplImage temp;
	temp.Create(src.size(), IPL_DEPTH_32F, 1);
	cvGoodFeaturesToTrack(&smat, GetCvArr(), temp, corners, corner_count, quality_level, min_distance
		, mask, block_size, use_harris, k);
}

/**********************************************************************//**
 *
 * }b`O
 *
 -----------------------------------------------------------------------
 * @param [in]	src		= 
 * @param [in]	templ	= C[W
 * @param [in]	method	= T@(CV_TM_***)
*//***********************************************************************/
void CCvIplImage::MatchTemplate(const cv::Mat& src, const cv::Mat& templ, int method)
{
	if( !IsValid() )
	{
		Create(cvSize(src.cols - templ.cols + 1, src.rows - templ.rows + 1), IPL_DEPTH_32F, 1);
	}
	CvMat smat = src;
	CvMat tmat = templ;
	cvMatchTemplate(&smat, &tmat, GetCvArr(), method);
}

/**********************************************************************//**
 *
 * }b`O
 *
 -----------------------------------------------------------------------
 * @param [in]	templ	= C[W
 * @param [in]	method	= T@(CV_TM_***)
 * @return }b`̈
*//***********************************************************************/
CvRect CCvIplImage::MatchTemplate(const cv::Mat& templ, int method)
{
	CvMat tmat = templ;
	CCvIplImage dst;
	dst.Create(cvSize(GetWidth() - templ.cols + 1, GetHeight() - templ.rows + 1), IPL_DEPTH_32F, 1);
	cvMatchTemplate(GetCvArr(), &tmat, dst, method);

	CvPoint loc;
	switch(method)
	{
	case CV_TM_SQDIFF:
	case CV_TM_SQDIFF_NORMED:
		loc = dst.GetMinLoc();
		break;
	default:
		loc = dst.GetMaxLoc();
		break;
	}
	return cvRect(loc.x, loc.y, loc.x + templ.cols, loc.y + templ.rows);
}

/**********************************************************************//**
 *
 * `}b`O
 *
 -----------------------------------------------------------------------
 * @param [in]	src			= C[W
 * @param [in]	method		= T@
 * @param [in]	parameter	= p[^(󖢎gp)
 * @return vx(0 ɋ߂قǈv)
*//***********************************************************************/
double CCvIplImage::MatchShape(const cv::Mat& src, int method, double parameter)
{
	CvMat smat = src;
	return cvMatchShapes(GetCvArr(), &smat, method, parameter);
}

/**********************************************************************//**
 *
 * ROI ̃Zbg
 *
 -----------------------------------------------------------------------
 * @param [in]	rc	= ROI ͈
*//***********************************************************************/
void CCvIplImage::SetROI(const CvRect& rc)
{
	cvSetImageROI(m_pImage, rc);
}

/**********************************************************************//**
 *
 * ROI ̎擾
 *
 -----------------------------------------------------------------------
 * @return ROI ͈
*//***********************************************************************/
CvRect CCvIplImage::GetROI(void) const
{
	return cvGetImageROI(m_pImage);
}

/**********************************************************************//**
 *
 * ROI ̃Zbg
 *
*//***********************************************************************/
void CCvIplImage::ResetROI(void)
{
	cvResetImageROI(m_pImage);
}

/**********************************************************************//**
 *
 * COI ̃Zbg
 *
 -----------------------------------------------------------------------
 * @param [in]	coi	= COI
*//***********************************************************************/
void CCvIplImage::SetCOI(int coi)
{
	cvSetImageCOI(m_pImage, coi);
}

/**********************************************************************//**
 *
 * COI ̎擾
 *
 -----------------------------------------------------------------------
 * @return COI
*//***********************************************************************/
int CCvIplImage::GetCOI(void) const
{
	return cvGetImageCOI(m_pImage);
}

/**********************************************************************//**
 *
 *
 *
*//***********************************************************************/
void CCvIplImage::MinMaxLoc(double* min_val, double* max_val, CvPoint* min_loc, CvPoint* max_loc, const CvArr* mask) const
{
	cvMinMaxLoc(GetCvArr(), min_val, max_val, min_loc, max_loc, mask);
}

/**********************************************************************//**
 *
 *
 *
 -----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
CvPoint CCvIplImage::GetMinLoc(const CvArr* mask) const
{
	double min_val, max_val;
	CvPoint min_loc;
	MinMaxLoc(&min_val, &max_val, &min_loc, nullptr, mask);
	return min_loc;
}

/**********************************************************************//**
 *
 *
 *
 -----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
CvPoint CCvIplImage::GetMaxLoc(const CvArr* mask) const
{
	double min_val, max_val;
	CvPoint max_loc;
	MinMaxLoc(&min_val, &max_val, nullptr, &max_loc, mask);
	return max_loc;
}

/**********************************************************************//**
 *
 * C擾
 *
 -----------------------------------------------------------------------
 * @param [in]	pt1				= _1
 * @param [in]	pt2				= _2
 * @param [in]	connectivity	= 4 or 8
 * @param [in]	left_to_right	= ɍEɎ邩
 * @return	CCe[^
*//***********************************************************************/
CCvIplImage::line::iterator CCvIplImage::Line(const CvPoint& pt1, const CvPoint& pt2, int connectivity, int left_to_right)
{
	CvLineIterator it;
	cvInitLineIterator(GetCvArr(), pt1, pt2, &it, connectivity, left_to_right);
	return &it;
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	pts			= _z
 * @param [in]	npts		= _z
 * @param [in]	contours	= 
 * @param [in]	is_closed	= 
 * @param [in]	color		= F
 * @param [in]	thickness	= 
 * @param [in]	line_type	= C^Cv
 * @param [in]	shift		= 
*//***********************************************************************/
void CCvIplImage::DrawPolyLine(CvPoint** pts, const int* npts, int contours, int is_closed, const CvScalar& color
		, int thickness, int line_type, int shift)
{
	cvPolyLine(GetCvArr(), pts, npts, contours, is_closed, color, thickness, line_type, shift);
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	pt1			= _1
 * @param [in]	pt2			= _2
 * @param [in]	color		= F
 * @param [in]	thickness	= 
 * @param [in]	line_type	= C^Cv
 * @param [in]	shift		= 
*//***********************************************************************/
void CCvIplImage::DrawLine(const CvPoint& pt1, const CvPoint& pt2, const CvScalar& color
		, int thickness, int line_type, int shift)
{
	cvLine(GetCvArr(), pt1, pt2, color, thickness, line_type, shift);
}

/**********************************************************************//**
 *
 * `
 *
 -----------------------------------------------------------------------
 * @param [in]	pt1			= ̓_
 * @param [in]	pt2			= E̓_
 * @param [in]	color		= F
 * @param [in]	thickness	= 
 * @param [in]	line_type	= C^Cv
 * @param [in]	shift		= 
*//***********************************************************************/
void CCvIplImage::DrawRectangle(const CvPoint& pt1, const CvPoint& pt2, const CvScalar& color
		, int thickness, int line_type, int shift)
{
	cvRectangle(GetCvArr(), pt1, pt2, color, thickness, line_type, shift);
}

/**********************************************************************//**
 *
 * `
 *
 -----------------------------------------------------------------------
 * @param [in]	rc			= ̈
 * @param [in]	color		= F
 * @param [in]	thickness	= 
 * @param [in]	line_type	= C^Cv
 * @param [in]	shift		= 
 * @return	
*//***********************************************************************/
void CCvIplImage::DrawRectangle(const CvRect& rc, const CvScalar& color
		, int thickness, int line_type, int shift)
{
	cvRectangleR(GetCvArr(), rc, color, thickness, line_type, shift);
}

/**********************************************************************//**
 *
 * ~`
 *
 -----------------------------------------------------------------------
 * @param [in]	center		= _
 * @param [in]	radius		= a
 * @param [in]	color		= F
 * @param [in]	thickness	= 
 * @param [in]	line_type	= C^Cv
 * @param [in]	shift		= 
*//***********************************************************************/
void CCvIplImage::DrawCircle(const CvPoint& center, int radius, const CvScalar& color
		, int thickness, int line_type, int shift)
{
	cvCircle(GetCvArr(), center, radius, color, thickness, line_type, shift);
}

/**********************************************************************//**
 *
 * ȉ~
 *
 -----------------------------------------------------------------------
 * @param [in]	center		= _
 * @param [in]	axes		= 
 * @param [in]	angle		= 
 * @param [in]	start_angle	= 
 * @param [in]	end_angle	= 
 * @param [in]	color		= F
 * @param [in]	thickness	= 
 * @param [in]	line_type	= C^Cv
 * @param [in]	shift		= 
*//***********************************************************************/
void CCvIplImage::DrawEllipse(const CvPoint& center, const CvSize& axes
		, double angle, double start_angle, double end_angle, const CvScalar& color
		, int thickness, int line_type, int shift)
{
	cvEllipse(GetCvArr(), center, axes, angle, start_angle, end_angle, color, thickness, line_type, shift);
}

/**********************************************************************//**
 *
 * ȉ~
 *
 -----------------------------------------------------------------------
 * @param [in]	box			= 
 * @param [in]	color		= F
 * @param [in]	thickness	= 
 * @param [in]	line_type	= C^Cv
 * @param [in]	shift		= 
*//***********************************************************************/
void CCvIplImage::DrawEllipse(const CvBox2D& box, const CvScalar& color
		, int thickness, int line_type, int shift)
{
	cvEllipseBox(GetCvArr(), box, color, thickness, line_type, shift);
}

/**********************************************************************//**
 *
 * ֊s`
 *
 -----------------------------------------------------------------------
 * @param [in]	contour			= 
 * @param [in]	external_color	= O̐F
 * @param [in]	hole_color		= ̐F
 * @param [in]	thickness		= 
 * @param [in]	line_type		= C^Cv
 * @param [in]	offset			= 
*//***********************************************************************/
void CCvIplImage::DrawContours(CvSeq* contour, const CvScalar& external_color, const CvScalar& hole_color, int max_level
		, int thickness, int line_type, const CvPoint& offset)
{
	cvDrawContours(GetCvArr(), contour, external_color, hole_color, max_level, thickness, line_type, offset);
}

/**********************************************************************//**
 *
 * eLXg`
 *
 -----------------------------------------------------------------------
 * @param [in]	text	= eLXg
 * @param [in]	org		= `N_
 * @param [in]	font	= tHg
 * @param [in]	color	= F
*//***********************************************************************/
void CCvIplImage::DrawText(LPCSTR text, const CvPoint& org, const CvFont* font, CvScalar color/* =CV_RGB */)
{
	cvPutText(GetCvArr(), text, org, font, color);
}

/**********************************************************************//**
 *
 *
 *
 -----------------------------------------------------------------------
 * @param [in]	pts			= _z
 * @param [in]	npts		= _z
 * @param [in]	color		= F
 * @param [in]	line_type	= C^Cv
 * @param [in]	shift		= 
*//***********************************************************************/
void CCvIplImage::FillConvexPoly(const CvPoint* pts, int npts, const CvScalar& color
		, int line_type, int shift)
{
	cvFillConvexPoly(GetCvArr(), pts, npts, color, line_type, shift);
}

/**********************************************************************//**
 *
 * p`hԂ
 *
 -----------------------------------------------------------------------
 * @param [in]	pts			= _z
 * @param [in]	npts		= _z
 * @param [in]	contours	= 
 * @param [in]	color		= F
 * @param [in]	line_type	= C^Cv
 * @param [in]	shift		= 
*//***********************************************************************/
void CCvIplImage::FillPoly(CvPoint** pts, const int* npts, int contours, const CvScalar& color
		, int line_type, int shift)
{
	cvFillPoly(GetCvArr(), pts, npts, contours, color, line_type, shift);
}

/**********************************************************************//**
 *
 * sNZJ[̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	x	= xW
 * @param [in]	y	= yW
 * @return	sNZRGBA
*//***********************************************************************/
bool CCvIplImage::GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const
{
	const u8* addr = (const u8*)m_pImage->imageData + GetWidth() * y + x * GetChannels();
	if( GetDepth() != 8 ) return false;

	rgba.a = 0xFF;
	switch( GetChannels() )
	{
	case 1:
		rgba.b = rgba.g = rgba.r = *addr;
		break;
	case 3:
		{
			const IrisBGR888* tmp = pointer_cast<const IrisBGR888*>(addr);
			rgba.b = tmp->b;
			rgba.g = tmp->g;
			rgba.r = tmp->r;
		}
		break;
	default:
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * sNZJ[̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	x		= xW
 * @param [in]	y		= yW
 * @param [in]	rgba	= sNZRGBA
*//***********************************************************************/
bool CCvIplImage::SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba)
{
	u8* addr = (u8*)m_pImage->imageData + GetWidth() * y + x * GetChannels();
	if( GetDepth() != 8 ) return false;
	switch( GetChannels() )
	{
	//case 1:
	//	break;
	case 3:
		{
			IrisBGR888* tmp = pointer_cast<IrisBGR888*>(addr);
			tmp->b = rgba.b;
			tmp->g = rgba.g;
			tmp->r = rgba.r;
		}
		break;
	default:
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * IPL_DEPTH_*** ̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	cv_depth	= 
*//***********************************************************************/
int CCvIplImage::GetIplDepth(int cv_depth)
{
	int depth = CV_MAT_DEPTH(cv_depth);
	switch(depth)
	{
	case CV_1F:
		return IPL_DEPTH_1U;
	case CV_8S:
		return IPL_DEPTH_8S;
	case CV_8U:
		return IPL_DEPTH_8U;
	case CV_16S:
		return IPL_DEPTH_16S;
	case CV_16U:
		return IPL_DEPTH_16U;
	case CV_32S:
		return IPL_DEPTH_32S;
	case CV_32F:
		return IPL_DEPTH_32F;
	case CV_64F:
		return IPL_DEPTH_64F;
	}
	return 0;
}

/**********************************************************************//**
 *
 * A^b`
 *
 -----------------------------------------------------------------------
 * @param [in]	pImage		= o^C[W
*//***********************************************************************/
void CCvIplImage::Attach(IplImage* pImage)
{
	IRIS_ASSERT( pImage != nullptr );
	m_pImage = pImage;
	//cvReleaseImage(&pImage);
}

/**********************************************************************//**
 *
 * f^b`
 *
 -----------------------------------------------------------------------
 * @return	ȑÕC[W
*//***********************************************************************/
IplImage* CCvIplImage::Detach(void)
{
	IplImage* pImage = m_pImage;
	m_pImage = nullptr;
	return pImage;
	//cvReleaseImage(&pImage);
}

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../gui/CvWindow.h"
#include "../math/CvAffineMatrix.h"
#include "../math/CvShape.h"
#include "CvConvKernel.h"
#include "CvFont.h"
#include "../../../iris_using.h"
#include "../../../iris_iostream.h"
#include <stdio.h>
#include <tchar.h>

//======================================================================
// test

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#endif
