//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvIplImage.h
 * @brief		OpenCV Image t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvIplImage_H_
#define INCG_IRIS_CvIplImage_H_

//======================================================================
// include
#include "../../../fnd/image/FndImage.h"
#include "../core/CvLine.h"
#include "../math/CvMatrix.h"
#include "../cv_inchead.h"

#ifdef _IRIS_SUPPORT_OPENCV
#include <opencv/highgui.h>

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	OpenCV C[WNX
*/
class CCvIplImage : public fnd::IImage
{
protected:
	IplImage*	m_pImage;	//!< C[W

public:
	typedef fnd::CIterator<CCvLineIteratorBase, CvLineIterator>	line;

public:
	// RXgN^
	CCvIplImage(void);
	CCvIplImage(const cv::Mat& mat);
	CCvIplImage(const CCvIplImage& rhs);
	// fXgN^
	virtual ~CCvIplImage(void);

public:
	/**
	 * @name operator
	 * @{
	*/
	operator IplImage*			(void)			{ return m_pImage; }
	operator const IplImage*	(void)	const	{ return m_pImage; }
	//operator CvMat				(void)			{ return m_Mat; }
	/**
	 * @}
	*/

public:
	// C[W̍쐬
	bool	Create(const CvSize& size, int depth, int channels);
	bool	CreateFromMatrix(const cv::Mat& mat);
	// C[W̃[h
	bool	Load(LPCSTR lpszPath, int flags=CV_LOAD_IMAGE_COLOR);
	// C[W̕ۑ
	bool	Save(LPCSTR lpszPath, const int* params) const;
	// N[
	void	Clone(const cv::Mat& src);
	// 
	void	Release(void);

public:
	// LȃC[Wǂ
	virtual bool	IsValid(void)	const;

	// C[WTCY̎擾
			CvSize	GetSize(void) const;
	// C[W̎擾
	virtual	s32		GetWidth(void) const;
	// C[W̎擾
	virtual	s32		GetHeight(void) const;
	// [x̎擾
			int		GetDepthFlag(void) const;
			int		GetDepth(void) const;
	// `l̎擾
			int		GetChannels(void) const;

public:
	// ㏑Rs[
	void	Copy(const cv::Mat& cpy, const cv::Mat& mask);
	// 
	void	Split(CvArr* dst0, CvArr* dst1, CvArr* dst2, CvArr* dst3) const;

public:
	// 臒l
	void	Threshold(const cv::Mat& src, double threshold, double max_value, int threshold_type);

public:
	// J[tH[}bg̕ϊ
	void	TranslateColor(const cv::Mat& src, int code);
	// ϊ
	void	Convert(const cv::Mat& src);
	// `ϊ
	void	ConvertScale(const cv::Mat& src, double scale, double shift=0.0);
	// `ϊ(8rbg^̔zɕϊ)
	void	ConvertScaleAbs(const cv::Mat& src, double scale, double shift=0.0);
	// XP[
	void	Scale(double scale, double shift=0.0);
	// TCY
	void	Resize(const cv::Mat& src, int interpolation=CV_INTER_LINEAR);
	void	Resize(int width, int height, int interpolation=CV_INTER_LINEAR);
	// AtBϊ
	void	WarpAffine(const cv::Mat& src, const cv::Mat& matrix
		, int flags=CV_INTER_LINEAR+CV_WARP_FILL_OUTLIERS, CvScalar fillval=cvScalarAll(0));
	// 
	void	Smooth(const cv::Mat& src, int smoothtype=CV_GAUSSIAN
		, int size1=3, int size2=0, double sigma1=0, double sigma2=0);
	// iu[j
	void	SmoothBlurNoScale(const cv::Mat& src, int size1=3, int size2=0);
	void	SmoothBlur(const cv::Mat& src, int size1=3, int siz2=0);
	// ilj
	void	SmoothMedian(const cv::Mat& src, int size=3);
	// iGbWێj
	void	SmoothBilateral(const cv::Mat& src, int size1=3, int size2=0);
	// iKEVAj
	void	SmoothGaussian(const cv::Mat& src, int size1=11, int size2=0, double sigma1=0, double sigma2=0);
	// tB^[
	void	Filter2D(const cv::Mat& src, const cv::Mat& kernel, const CvPoint& anchor=cvPoint(-1, -1));
	// tHW[ϊ
	void	MorphologyEx(const cv::Mat& src, cv::Mat& tmp, IplConvKernel* element, int operation, int iterations=1);
	// tHW[ϊ(Dilate)
	void	MorphologyDilate(const cv::Mat& src, IplConvKernel* element, int iterations=1);
	// tHW[ϊ(Erode)
	void	MorphologyErode(const cv::Mat& src, IplConvKernel* element, int iterations=1);
	// 𑜓xAbv
	void	PyrUp(const cv::Mat& src, int filter=CV_GAUSSIAN_5x5);
	// 𑜓x_E
	void	PyrDown(const cv::Mat& src, int filter=CV_GAUSSIAN_5x5);
	// ̈敪
	void	PyrSegmentation(const cv::Mat& src, CvMemStorage* storage, CvSeq** comp, int level, double threshold1, double threshold2);
	// ϒlVtgɂ摜̃ZOg
	void	PyrMeanShiftFiltering(const cv::Mat& src, double sp, double sr, int max_level=1
		, CvTermCriteria termcrit = cvTermCriteria(CV_TERMCRIT_ITER+CV_TERMCRIT_EPS, 5, 1));

public:
	// 
	void	GoodFeaturesToTrack(const cv::Mat& src, CvPoint2D32f* corners, int* corner_count
		, double  quality_level, double  min_distance
		, const CvArr* mask=nullptr, int block_size=3, int use_harris=0, double k=0.04);

public:
	// }b`O
	void	MatchTemplate(const cv::Mat& src, const cv::Mat& templ, int method);
	CvRect	MatchTemplate(const cv::Mat& templ, int method);
	// `}b`
	double	MatchShape(const cv::Mat& src, int method, double parameter=0.0);
public:

	// ROI ̃Zbg
	void	SetROI(const CvRect& rc);
	// ROI ̎擾
	CvRect	GetROI(void) const;
	// ROI ̃Zbg
	void	ResetROI(void);

	// COI ̃Zbg
	void	SetCOI(int coi);
	// COI ̎擾
	int		GetCOI(void) const;

	// LOC
	void	MinMaxLoc(double* min_val, double* max_val
		, CvPoint* min_loc=nullptr, CvPoint* max_loc=nullptr, const CvArr* mask=nullptr) const;
	CvPoint	GetMinLoc(const CvArr* mask=nullptr) const;
	CvPoint	GetMaxLoc(const CvArr* mask=nullptr) const;

public:
	// C擾
	line::iterator	Line(const CvPoint& pt1, const CvPoint& pt2, int connectivity=8, int left_to_right=0);

public:
	// `
	void	DrawLine(const CvPoint& pt1, const CvPoint& pt2, const CvScalar& color
		, int thickness=1, int line_type=8, int shift=0);
	void	DrawPolyLine(CvPoint** pts, const int* npts, int contours, int is_closed, const CvScalar& color
		, int thickness=1, int line_type=8, int shift=0);
	// ``
	void	DrawRectangle(const CvPoint& pt1, const CvPoint& pt2, const CvScalar& color
		, int thickness=1, int line_type=8, int shift=0);
	void	DrawRectangle(const CvRect& rc, const CvScalar& color
		, int thickness=1, int line_type=8, int shift=0);
	// ~``
	void	DrawCircle(const CvPoint& center, int radius, const CvScalar& color
		, int thickness, int line_type, int shift);
	// ȉ~`
	void	DrawEllipse(const CvPoint& center, const CvSize& axes
		, double angle, double start_angle, double end_angle, const CvScalar& color
		, int thickness=1, int line_type=8, int shift=0);
	void	DrawEllipse(const CvBox2D& box, const CvScalar& color
		, int thickness=1, int line_type=8, int shift=0);
	// ֊s`
	void	DrawContours(CvSeq* contour, const CvScalar& external_color, const CvScalar& hole_color, int max_level
		, int thickness=1, int line_type=8, const CvPoint& offset=cvPoint(0, 0));
	// eLXg`
	void	DrawText(LPCSTR text, const CvPoint& org, const CvFont* font, CvScalar color=cvScalarAll(0));


	// 
	void	FillConvexPoly(const CvPoint* pts, int npts, const CvScalar& color
		, int line_type=8, int shift=0);
	// p`hԂ
	void	FillPoly(CvPoint** pts, const int* npts, int contours, const CvScalar& color
		, int line_type=8, int shift=0);

public:
	/// sNZJ[̎擾
	virtual bool		GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const;
	/// sNZJ[̐ݒ
	virtual bool		SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba);

public:
	// CV_*** -> IPL_DEPTH_***
	static	int GetIplDepth(int cv_depth);

private:
	// A^b`
	virtual		void	Attach(IplImage* pImage);
	// f^b`
	IplImage*	Detach(void);
	// CvArr* 擾
	virtual		CvArr*	GetCvArr(void) const	{ return m_pImage; }
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
