//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvMorphology.h
 * @brief		OpenCv Matrix t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvMorphology_H_
#define INCG_IRIS_CvMorphology_H_

//======================================================================
// include
#include "CvImage.h"
#include "../../../iris_debug.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	Morphology NX
 * @tparam	OPERATION = Iy[V
*/
template<int OPERATION_>
class CCvMorphology : public CCvImage
{
	IRIS_STATIC_ASSERT( (OPERATION_ == CV_MOP_ERODE)
		|| (OPERATION_ == CV_MOP_DILATE)
		|| (OPERATION_ == CV_MOP_OPEN)
		|| (OPERATION_ == CV_MOP_CLOSE)
		|| (OPERATION_ == CV_MOP_GRADIENT)
		|| (OPERATION_ == CV_MOP_TOPHAT)
		|| (OPERATION_ == CV_MOP_BLACKHAT)
		);
public:
	static const int OPERATION = OPERATION_;
public:
	// RXgN^
	CCvMorphology(void);
	CCvMorphology(const cv::Mat& src, const CCvConvKernel& element, int iterations=1
		, int borderType=::cv::BORDER_CONSTANT, const cv::Scalar& bordefValue=::cv::morphologyDefaultBorderValue());
	CCvMorphology(const cv::Mat& src, const cv::Mat& kernel, const cv::Point& anchor=cv::Point(-1, -1), int iterations=1
		, int borderType=::cv::BORDER_CONSTANT, const cv::Scalar& bordefValue=::cv::morphologyDefaultBorderValue());

public:
	// 쐬
	void	Create(const cv::Mat& src, const cv::Mat& kernel, const cv::Point& anchor=cv::Point(-1, -1), int iterations=1
		, int borderType=::cv::BORDER_CONSTANT, const cv::Scalar& bordefValue=::cv::morphologyDefaultBorderValue());
	void	Create(const cv::Mat& src, const CCvConvKernel& element, int iterations=1
		, int borderType=::cv::BORDER_CONSTANT, const cv::Scalar& bordefValue=::cv::morphologyDefaultBorderValue());
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
