//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvFile.h
 * @brief		CvFileStorage t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvFile_H_
#define INCG_IRIS_CvFile_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "../memory/CvMemStorage.h"
#include "../cv_inchead.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	NX
*/
class CCvFile : public IIrisObject
{
protected:
	CvFileStorage*	m_pStorage;			//!< 
public:
	// RXgN^
	CCvFile(void);
	// fXgN^
	~CCvFile(void);

public:
	// J
	bool	Open(LPCSTR  lpFileName, CvMemStorage* pMem, int flags);
	// 
	void	Close(void);
	// JĂ邩ǂ
	bool	IsValid(void)	const	{ return m_pStorage != nullptr; }

public:
	/**
	 * @name operator
	 * @{
	*/
	operator CvFileStorage*			(void)			{ return m_pStorage; }
	operator const CvFileStorage*	(void)	const	{ return m_pStorage; }
	/**
	 * @}
	*/
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
