//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvAffineMatrix.cpp
 * @brief		OpenCv Matrix t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvAffineMatrix_CPP_

//======================================================================
// include
#include "CvAffineMatrix.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvAffineMatrix::CCvAffineMatrix(void)
{
	Create();
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	center	= Sʒu
 * @param [in]	angle	= ]pidegreej
*//***********************************************************************/
CCvAffineMatrix::CCvAffineMatrix(const CvPoint2D32f& center, float angle)
{
	Create(center, angle);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	center	= Sʒu
 * @param [in]	angle	= ]pidegreej
 * @param [in]	scale	= XP[
 *//***********************************************************************/
CCvAffineMatrix::CCvAffineMatrix(const CvPoint2D32f& center, double angle, double scale)
{
	Create(center, angle, scale);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvAffineMatrix::~CCvAffineMatrix(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
*//***********************************************************************/
void CCvAffineMatrix::Create(void)
{
	CCvMatrix::Create(2, 3, CV_32F);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	center	= Sʒu
 * @param [in]	angle	= ]pidegreej
*//***********************************************************************/
void CCvAffineMatrix::Create(const CvPoint2D32f& center, float angle)
{
	float m[6];
	m[0] =  cosf( angle * F32_C(CV_PI) / 180.0f );
	m[1] = -sinf( angle * F32_C(CV_PI) / 180.0f );
	m[2] = center.x;
	m[3] = -m[1];
	m[4] = m[0];
	m[5] = center.y;
	CCvMatrix::Create(2, 3, CV_32F, m);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	center	= Sʒu
 * @param [in]	angle	= ]pidegreej
 * @param [in]	scale	= XP[
*//***********************************************************************/
void CCvAffineMatrix::Create(const CvPoint2D32f& center, double angle, double scale)
{
	CCvMatrix::Create(2, 3, CV_32F);
	Rotate2D(center, angle, scale);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	src	= ]O̎Op`
 * @param [in]	dst	= ]̎Op`
*//***********************************************************************/
void CCvAffineMatrix::GetAffineTransform(const CvPoint2D32f* src, const CvPoint2D32f* dst)
{
	CvMat mat = m_Mat;
	cvGetAffineTransform(src, dst, &mat);
}

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif
