//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvAffineMatrix.h
 * @brief		OpenCv Matrix t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvAffineMatrix_H_
#define INCG_IRIS_CvAffineMatrix_H_

//======================================================================
// include
#include "CvMatrix.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	Matrix NX
*/
class CCvAffineMatrix : public CCvMatrix
{
public:
	// RXgN^
	CCvAffineMatrix(void);
	CCvAffineMatrix(const CvPoint2D32f& center, float angle);
	CCvAffineMatrix(const CvPoint2D32f& center, double angle, double scale);
	// fXgN^
	virtual ~CCvAffineMatrix(void);

public:
	// 쐬
	void	Create(void);
	void	Create(const CvPoint2D32f& center, float angle);
	void	Create(const CvPoint2D32f& center, double angle, double scale);
public:
	// AtBs̎擾
	void GetAffineTransform(const CvPoint2D32f* src, const CvPoint2D32f* dst);
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
