//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvShape.h
 * @brief		OpenCv ` t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvShape_H_
#define INCG_IRIS_CvShape_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "../cv_inchead.h"
#include "../../../iris_debug.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	2D ` NX
*/
template<int VERTEX_NUM_>
class CCvShape : public IIrisObject
{
	typedef CCvShape<VERTEX_NUM_>	_Myt;

public:
	static const int VERTEX_NUM = VERTEX_NUM_;

	IRIS_STATIC_ASSERT( VERTEX_NUM > 0 );
protected:
	CvPoint2D32f	m_Vertex[VERTEX_NUM];
public:
	// RXgN^
	CCvShape(void) {}
	// fXgN^
	~CCvShape(void) {}

public:
	/**
	 * @name operator
	 * @{
	*/
	operator		CvPoint2D32f*	(void)			{ return m_Vertex; }
	operator const	CvPoint2D32f*	(void)	const	{ return m_Vertex; }
			CvPoint2D32f&	operator [] (int idx)			{ return m_Vertex[idx]; }
	const	CvPoint2D32f&	operator [] (int idx)	const	{ return m_Vertex[idx]; }
	/**
	 * @}
	*/
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
