//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvMemStorage.cpp
 * @brief		CvMemStorage t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvMemStorage_CPP_

//======================================================================
// include
#include "CvMemStorage.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvMemStorage::CCvMemStorage(void)
: m_pMem(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	blk_size	= ubNTCY
*//***********************************************************************/
CCvMemStorage::CCvMemStorage(int blk_size)
: m_pMem(nullptr)
{
	Create(blk_size);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvMemStorage::~CCvMemStorage(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	blk_size	= ubNTCY
 * @return	
*//***********************************************************************/
bool CCvMemStorage::Create(int blk_size)
{
	Release();
	m_pMem = cvCreateMemStorage(blk_size);
	return m_pMem != nullptr;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CCvMemStorage::Release(void)
{
	if( m_pMem != nullptr )
	{
		cvReleaseMemStorage(&m_pMem);
		m_pMem = nullptr;
	}
}

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif
