//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXObserver.h
 * @brief		FBX observerNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXObserver_H_
#define INCG_IRIS_FBXObserver_H_

//======================================================================
// include
#include "../../fnd/container/FndObserver.h"

#ifdef _IRIS_SUPPORT_FBX
#include "fbx_inchead.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// delare
class CFBXManager;
class IFBXObject;

//======================================================================
// class
/**
 * @ingroup	FBX
 * @brief	FBX֘AIuWFNgǗNX
*/
class CFBXObserverSubject : public fnd::CObserverSubject<IFBXObject>
{
	CFBXManager*	m_pMngr;	//!< Ǘ҃NX
public:
	/// RXgN^
	CFBXObserverSubject(CFBXManager* pMngr) : m_pMngr(pMngr) {}
	// fXgN^
	virtual ~CFBXObserverSubject(void);
public:
	/// ManagerNX̎擾
	CFBXManager*	GetManager(void)	{ return m_pMngr; }
};

/**
 * @ingroup	FBX
 * @brief	FBX SDK IuWFNgIuU[o[
*/
class IFBXObject : public fnd::CObserver<IFBXObject>
{
public:
	/// RXgN^
	IFBXObject(void)	{}
	/// fXgN^
	virtual ~IFBXObject(void) { Release(); }

public:
	/// 
	virtual void	Release(void)	{}
	/// }lW[NX̎擾
	CFBXManager*	GetManager(void)
	{
		CFBXObserverSubject* pSubject = static_cast<CFBXObserverSubject*>(GetSubject());
		if( pSubject == nullptr ) return nullptr;
		return pSubject->GetManager();
	}
};

/// fXgN^
inline CFBXObserverSubject::~CFBXObserverSubject(void)
{
	value_ptr curr = GetObservers();
	while(curr != nullptr)
	{
		curr->Release();
		curr = curr->GetNext();
	}
}

}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
