//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXScene.h
 * @brief		FBX SDK sceneNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXScene_H_
#define INCG_IRIS_FBXScene_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_FBX
#include "../../fnd/types/FndExecutor.h"
#include "FBXObject.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/**
 * @ingroup	FBX
 * @brief	FBX SDK Scene
*/
class CFBXScene : public CFBXObject<KFbxScene>, public fnd::CExecutor
{
public:
	// RXgN^
	CFBXScene(void);
	// fXgN^
	virtual ~CFBXScene(void);

public:
	// XV
	virtual	void	Update(xf32 time);
	// `
	virtual	void	Draw(void);

protected:
	virtual	void	Update(KFbxNode* pNode, xf32 time);
	virtual	void	Draw(KFbxNode* pNode);
};


}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
