//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXMaterial.h
 * @brief		FBX SDK materialNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXMaterial_H_
#define INCG_IRIS_FBXMaterial_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_FBX
#include "../../../fnd/types/FndExecutor.h"
#include "../FBXObject.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/**
 * @ingroup	FBX
 * @brief	FBX SDK Material
*/
class CFBXMaterial : public IFBXObjectBase<KFbxSurfaceMaterial>//, public fnd::CExecutor
{
	typedef IFBXObjectBase<KFbxSurfaceMaterial>	_Base;
public:
	// RXgN^
	CFBXMaterial(void);
	// RXgN^
	CFBXMaterial(kfbx_ptr ptr);
	// RXgN^
	CFBXMaterial(CFBXMaterial& obj);
	// fXgN^
	virtual ~CFBXMaterial(void);

public:
	// ArGg̎擾
	bool	GetAmbient(fbxDouble3& rAmbient) const;
	// ft[Y̎擾
	bool	GetDiffuse(fbxDouble3& rDiffuse) const;
	// G~bVu̎擾
	bool	GetEmissive(fbxDouble3& rEmissive) const;
	// ov̎擾
	bool	GetBump(fbxDouble3& rBump) const;
	// x̎擾
	bool	GetTransparency(fbxDouble1& rTrans) const;
	// XyL̎擾
	bool	GetSpecular(fbxDouble3& rSpecular) const;
	// ̎擾
	bool	GetShininess(fbxDouble1& rShininess) const;
	// ˂̎擾
	bool	GetReflection(fbxDouble1& rReflection) const;

public:
	// LambertpĂ邩ǂ
	bool	IsLambert(void) const;
	// PhongpĂ邩ǂ
	bool	IsPhong(void) const;

public:
	// KFbxSurfaceLambert*̎擾
	KFbxSurfaceLambert*	GetLambert(void) const;
	// KFbxSurfacePhong*̎擾
	KFbxSurfacePhong*	GetPhong(void) const;
};


}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
